/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.SpellProperties;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class SpellPropertiesManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "spells";
    private Map<ResourceLocation, SpellProperties> propertiesMap = new HashMap<ResourceLocation, SpellProperties>();

    public SpellPropertiesManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public SpellProperties getPropertiesFor(Spell spell) {
        ResourceLocation res = ModSpells.SPELL_REGISTRY.get().getIDFrom((Object)spell);
        return this.propertiesMap.getOrDefault(res, SpellProperties.DEFAULT_PROP);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder propertiesBuilder = new ImmutableMap.Builder();
        data.forEach((key, el) -> {
            try {
                SpellProperties props = (SpellProperties)SpellProperties.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                propertiesBuilder.put(key, (Object)props);
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldnt parse spell properties json {} {}", key, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.propertiesMap = propertiesBuilder.build();
    }
}

