/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.EntityType;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class StructureBossManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "runecraftory_bosses";
    private Map<ResourceLocation, BossSpawnList> spawnList = new HashMap<ResourceLocation, BossSpawnList>();

    public StructureBossManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    @Nullable
    public BossSpawnList getBoss(ResourceLocation id) {
        return this.spawnList.get(id);
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        data.forEach((key, el) -> {
            try {
                BossSpawnList list = (BossSpawnList)BossSpawnList.CODEC.parse((DynamicOps)JsonOps.INSTANCE, el).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0));
                builder.put(key, (Object)list);
            }
            catch (Exception ex) {
                RuneCraftory.LOGGER.error("Couldn't parse boss spawn list json {} {}", key, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.spawnList = builder.build();
    }

    public static class BossSpawnList {
        public static final Codec<BossSpawnList> CODEC = SimpleWeightedRandomList.m_146264_((Codec)Registry.f_122826_.m_194605_()).xmap(BossSpawnList::new, b -> b.list);
        private final SimpleWeightedRandomList<EntityType<?>> list;
        private final Set<EntityType<?>> direct;

        public BossSpawnList(SimpleWeightedRandomList<EntityType<?>> list) {
            this.list = list;
            this.direct = this.list.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).collect(Collectors.toUnmodifiableSet());
        }

        public static BossSpawnList of(EntityType<?> type) {
            return new BossSpawnList(SimpleWeightedRandomList.m_185862_(type));
        }

        public Optional<EntityType<?>> getRandom(Random random) {
            return this.list.m_146266_(random);
        }

        public boolean has(EntityType<?> type) {
            return this.direct.contains(type);
        }
    }
}

