/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class NPCActionManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "npc_actions";
    public static final ResourceLocation DEFAULT_ID = new ResourceLocation("runecraftory", "default_action");
    private Map<ResourceLocation, NPCAttackActions> keyData = ImmutableMap.of();
    private Map<NPCAttackActions, ResourceLocation> dataKey = ImmutableMap.of();
    private List<NPCAttackActions> actions = List.of();

    public NPCActionManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCAttackActions get(ResourceLocation res) {
        return this.keyData.getOrDefault(res, NPCAttackActions.DEFAULT);
    }

    public ResourceLocation getId(NPCAttackActions data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCAttackActions getRandom(Random random) {
        if (this.actions.isEmpty()) {
            return NPCAttackActions.DEFAULT;
        }
        return this.actions.get(random.nextInt(this.actions.size()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCAttackActions)NPCAttackActions.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc actions json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        this.actions = this.keyData.values().stream().toList();
    }
}

