/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.WeightedList;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedEntry;
import org.jetbrains.annotations.Nullable;

public class NPCDataManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "npc_data";
    public static final ResourceLocation DEFAULT_ID = new ResourceLocation("runecraftory", "default_npc");
    private Map<ResourceLocation, NPCData> keyData = ImmutableMap.of();
    private Map<NPCData, ResourceLocation> dataKey = ImmutableMap.of();
    private final WeightedList<NPCData> view = new WeightedList();
    private final WeightedList<NPCData> viewNoJobDef = new WeightedList();

    public NPCDataManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCData get(ResourceLocation res) {
        return this.keyData.getOrDefault(res, NPCData.DEFAULT_DATA);
    }

    public boolean has(ResourceLocation res) {
        return this.keyData.containsKey(res);
    }

    public ResourceLocation getId(NPCData data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCData getRandom(Random random, Predicate<NPCData> func, @Nullable Predicate<NPCData> other) {
        return this.view.getRandom(random, NPCData.DEFAULT_DATA, func, other);
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCData)NPCData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(true, s -> RuneCraftory.LOGGER.error("NPC: {} - {}", fres, s))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc data json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        this.view.setList(this.keyData.values().stream().map(d -> WeightedEntry.m_146290_((Object)d, (int)d.weight())).toList());
        this.viewNoJobDef.setList(this.keyData.values().stream().filter(d -> d.profession().isEmpty()).map(d -> WeightedEntry.m_146290_((Object)d, (int)d.weight())).toList());
    }
}

