/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;

public class NPCLookManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "npc_looks";
    public static final ResourceLocation DEFAULT_ID = new ResourceLocation("runecraftory", "default_look");
    private Map<ResourceLocation, NPCLook> keyData = ImmutableMap.of();
    private Map<NPCLook, ResourceLocation> dataKey = ImmutableMap.of();
    private List<NPCLook> selectable = ImmutableList.of();

    public NPCLookManager() {
        super(GsonInstances.GSON, DIRECTORY);
    }

    public NPCLook get(ResourceLocation res) {
        return this.keyData.getOrDefault(res, NPCLook.DEFAULT_LOOK);
    }

    public ResourceLocation getId(NPCLook data) {
        return this.dataKey.getOrDefault(data, DEFAULT_ID);
    }

    public NPCLook getRandom(Random random, boolean male) {
        if (this.selectable.isEmpty()) {
            return NPCLook.DEFAULT_LOOK;
        }
        List<NPCLook> looks = this.selectable.stream().filter(l -> l.gender() == NPCData.Gender.UNDEFINED || l.gender() == (male ? NPCData.Gender.MALE : NPCData.Gender.FEMALE)).toList();
        if (looks.isEmpty()) {
            return NPCLook.DEFAULT_LOOK;
        }
        return looks.get(random.nextInt(looks.size()));
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        map.forEach((fres, el) -> {
            if (!fres.equals((Object)DEFAULT_ID)) {
                try {
                    JsonObject obj = el.getAsJsonObject();
                    builder.put(fres, (Object)((NPCLook)NPCLook.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0))));
                }
                catch (Exception ex) {
                    RuneCraftory.LOGGER.error("Couldnt parse npc look json {} {}", fres, (Object)ex);
                    ex.fillInStackTrace();
                }
            }
        });
        builder.put((Object)NPCLook.DEFAULT_LOOK_ID, (Object)NPCLook.DEFAULT_LOOK);
        this.keyData = builder.build();
        ImmutableMap.Builder reverse = ImmutableMap.builder();
        this.keyData.forEach((resourceLocation, data) -> reverse.put(data, resourceLocation));
        this.dataKey = reverse.build();
        ImmutableList.Builder selectable = ImmutableList.builder();
        this.keyData.entrySet().stream().filter(e -> ((NPCLook)e.getValue()).weight() > 0).forEach(e -> selectable.add((Object)((NPCLook)e.getValue())));
        this.selectable = selectable.build();
    }
}

