/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.datapack.manager.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.GsonInstances;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class NameManager
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonObject>> {
    public static final String DIRECTORY = "names";
    private Map<String, List<String>> surnames;
    private Map<String, List<String>> maleNames;
    private Map<String, List<String>> femaleNames;

    public String getRandomSurname(Random random, String lang) {
        if (this.surnames.isEmpty()) {
            return null;
        }
        List<String> names = this.surnames.get(lang);
        if (names == null) {
            return null;
        }
        return names.get(random.nextInt(names.size()));
    }

    public String getRandomName(Random random, String lang, boolean male) {
        List<String> names;
        if (male) {
            if (this.maleNames.isEmpty()) {
                return null;
            }
            names = this.maleNames.get(lang);
        } else {
            if (this.femaleNames.isEmpty()) {
                return null;
            }
            names = this.femaleNames.get(lang);
        }
        if (names == null) {
            return null;
        }
        return names.get(random.nextInt(names.size()));
    }

    public String getRandomFullName(Random random, boolean male) {
        List langs;
        if (male) {
            langs = this.maleNames.keySet().stream().toList();
            if (langs.isEmpty()) {
                return null;
            }
        } else {
            langs = this.femaleNames.keySet().stream().toList();
        }
        if (langs.isEmpty()) {
            return null;
        }
        String lang = (String)langs.get(random.nextInt(langs.size()));
        return this.getRandomName(random, lang, male) + " " + this.getRandomSurname(random, lang);
    }

    protected Map<ResourceLocation, JsonObject> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        int i = DIRECTORY.length() + 1;
        for (ResourceLocation fileRes : resourceManager.m_6540_(DIRECTORY, string -> string.endsWith(".json"))) {
            String path = fileRes.m_135815_();
            path = path.substring(i, path.length() - ".json".length());
            ResourceLocation res = new ResourceLocation(fileRes.m_135827_(), path);
            try {
                Resource resource = resourceManager.m_142591_(fileRes);
                try {
                    InputStream inputStream = resource.m_6679_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonObject obj = (JsonObject)GsonHelper.m_13776_((Gson)GsonInstances.GSON, (Reader)reader, JsonObject.class);
                        if (obj == null) continue;
                        map.put(res, obj);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RuneCraftory.LOGGER.error("Couldn't parse data file {} {}", (Object)res, (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonObject> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder surnames = ImmutableMap.builder();
        ImmutableMap.Builder maleNames = ImmutableMap.builder();
        ImmutableMap.Builder femaleNames = ImmutableMap.builder();
        data.forEach((res, arr) -> {
            ImmutableList.Builder lang_surnames = ImmutableList.builder();
            ImmutableList.Builder lang_maleNames = ImmutableList.builder();
            ImmutableList.Builder lang_femaleNames = ImmutableList.builder();
            GsonHelper.m_13832_((JsonObject)arr, (String)"surnames", (JsonArray)new JsonArray()).forEach(e -> lang_surnames.add((Object)e.getAsString()));
            GsonHelper.m_13832_((JsonObject)arr, (String)"male_names", (JsonArray)new JsonArray()).forEach(e -> lang_maleNames.add((Object)e.getAsString()));
            GsonHelper.m_13832_((JsonObject)arr, (String)"female_names", (JsonArray)new JsonArray()).forEach(e -> lang_femaleNames.add((Object)e.getAsString()));
            surnames.put((Object)res.m_135815_(), (Object)lang_surnames.build());
            maleNames.put((Object)res.m_135815_(), (Object)lang_maleNames.build());
            femaleNames.put((Object)res.m_135815_(), (Object)lang_femaleNames.build());
        });
        this.surnames = surnames.build();
        this.maleNames = maleNames.build();
        this.femaleNames = femaleNames.build();
    }
}

