/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.effects;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BathEffect
extends MobEffect {
    private static final VoxelShape VIRTUAL_FENCE_POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public BathEffect() {
        super(MobEffectCategory.BENEFICIAL, 0);
    }

    public void m_6742_(LivingEntity living, int amplifier) {
        BlockState state;
        if (living.m_20069_() && (state = living.m_146900_()).m_60819_().m_205070_(FluidTags.f_13131_) && BathEffect.isSmokeyPos(living.f_19853_, living.m_142538_())) {
            living.m_5634_(living.m_21233_() * 0.04f);
            if (living instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)living;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    data.refreshRunePoints((Player)player, Math.max(1, (int)((float)data.getMaxRunePoints() * 0.03f)));
                    LevelCalc.levelSkill(player, data, EnumSkills.BATH, 2.0f);
                });
            }
        }
        super.m_6742_(living, amplifier);
    }

    public static boolean isSmokeyPos(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            BlockPos blockPos = pos.m_6625_(i);
            BlockState blockState = level.m_8055_(blockPos);
            if (BathEffect.isValidState(blockState)) {
                return true;
            }
            boolean bl = Shapes.m_83157_((VoxelShape)VIRTUAL_FENCE_POST, (VoxelShape)blockState.m_60742_((BlockGetter)level, pos, CollisionContext.m_82749_()), (BooleanOp)BooleanOp.f_82689_);
            if (!bl) continue;
            BlockState blockState2 = level.m_8055_(blockPos.m_7495_());
            return BathEffect.isValidState(blockState2);
        }
        return false;
    }

    private static boolean isValidState(BlockState state) {
        if (state.m_204336_(BlockTags.f_13087_)) {
            return state.m_61138_((Property)CampfireBlock.f_51227_) && (Boolean)state.m_61143_((Property)CampfireBlock.f_51227_) != false;
        }
        return state.m_204336_(RunecraftoryTags.ONSEN_PROVIDER);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

