/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.effects;

import io.github.flemmli97.runecraftory.common.network.S2CEntityDataSync;
import io.github.flemmli97.runecraftory.platform.ExtendedEffect;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;

public class PermanentEffect
extends MobEffect
implements ExtendedEffect {
    private final S2CEntityDataSync.Type packetType;
    private final List<ItemStack> empty = List.of();
    private int tickDelay = 5;

    public PermanentEffect(MobEffectCategory type, int color, S2CEntityDataSync.Type packetType) {
        super(type, color);
        this.packetType = packetType;
    }

    private static void sendPacket(LivingEntity entity, S2CEntityDataSync.Type type, boolean flag) {
        Platform.INSTANCE.getEntityData(entity).ifPresent(data -> {
            switch (type) {
                case POISON: {
                    data.setPoison(entity, flag);
                    break;
                }
                case SLEEP: {
                    data.setSleeping(entity, flag);
                    break;
                }
                case PARALYSIS: {
                    data.setParalysis(entity, flag);
                    break;
                }
                case COLD: {
                    data.setCold(entity, flag);
                    break;
                }
                case INVIS: {
                    data.setInvis(entity, flag);
                    break;
                }
                case ORTHOVIEW: {
                    data.setOrthoView(entity, flag);
                }
            }
        });
    }

    public PermanentEffect setTickDelay(int value) {
        this.tickDelay = value;
        return this;
    }

    public void m_6742_(LivingEntity living, int amplifier) {
        MobEffectInstance inst = living.m_21124_((MobEffect)this);
        if (!(living.f_19853_.f_46443_ || inst != null && inst.m_19557_() > 1)) {
            living.m_7292_(new MobEffectInstance((MobEffect)this, Integer.MAX_VALUE, 0, false, false, false));
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return duration % this.tickDelay == 1;
    }

    public void m_6386_(LivingEntity entity, AttributeMap manager, int amplifier) {
        PermanentEffect.sendPacket(entity, this.packetType, false);
        super.m_6386_(entity, manager, amplifier);
    }

    public void m_6385_(LivingEntity entity, AttributeMap manager, int amplifier) {
        PermanentEffect.sendPacket(entity, this.packetType, true);
        super.m_6385_(entity, manager, amplifier);
    }

    @Override
    public List<ItemStack> getCurativeItems() {
        return this.empty;
    }
}

