/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.datapack.EntityProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.ai.FollowOwnerGoalMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.HurtByTargetPredicate;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtAliveGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RandomLookGoalAlive;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RiderAttackTargetGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.TendCropsGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.control.MoveControlerEx;
import io.github.flemmli97.runecraftory.common.entities.data.MobUpdateHandler;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.DailyMonsterUpdater;
import io.github.flemmli97.runecraftory.common.entities.utils.ExtendedEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.IExtendedMob;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.SleepingEntity;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2COpenCompanionGui;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.TamingTracker;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModCriteria;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.BarnData;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.mixin.CombatTrackerAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AoeAttackEntity;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class BaseMonster
extends PathfinderMob
implements Enemy,
IAnimated,
IExtendedMob,
ExtendedEntity,
SleepingEntity,
TargetableOpponent,
AoeAttackEntity,
MobUpdateHandler,
MobAttackExt {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Byte> MOVE_FLAGS = SynchedEntityData.m_135353_(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> BEHAVIOUR_DATA = SynchedEntityData.m_135353_(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> PLAY_DEATH_STATE = SynchedEntityData.m_135353_(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FRIEND_POINTS_SYNC = SynchedEntityData.m_135353_(BaseMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static boolean TESTING = false;
    public final Predicate<LivingEntity> targetPred = e -> {
        if (e != this) {
            Mob mob;
            if (this.m_6688_() instanceof Player) {
                return false;
            }
            if (this.isTamed()) {
                return e instanceof Enemy && EntityUtils.canAttackOwned(e, false, true, this.targetPred);
            }
            if (e instanceof Player) {
                return e.m_142066_();
            }
            if (e instanceof Mob && this == (mob = (Mob)e).m_5448_()) {
                return true;
            }
            return EntityUtils.canMonsterTargetNPC((Entity)e) || EntityUtils.canAttackOwned(e, false, false, entity -> entity instanceof Player ? entity.m_142066_() : this.targetPred.test((LivingEntity)entity));
        }
        return false;
    };
    public final Predicate<LivingEntity> defendPred = e -> {
        if (e != this) {
            if (this.m_6688_() instanceof Player) {
                return false;
            }
            if (this.isTamed()) {
                return !e.m_142081_().equals(this.m_142504_()) && !this.m_142504_().equals(EntityUtils.tryGetOwner(e));
            }
            return true;
        }
        return false;
    };
    private final EntityProperties prop;
    public NearestAttackableTargetGoal<Player> targetPlayer = this.createTargetGoalPlayer();
    public NearestAttackableTargetGoal<Mob> targetMobs = this.createTargetGoalMobs();
    public FloatGoal swimGoal = new FloatGoal((Mob)this);
    public FollowOwnerGoalMonster followOwnerGoal = new FollowOwnerGoalMonster(this, 1.05, 9.0f, 2.0f, 20.0f);
    public RandomStrollGoal wander = new RestrictedWaterAvoidingStrollGoal(this, 1.0);
    public HurtByTargetPredicate hurt = new HurtByTargetPredicate(this, this.defendPred);
    public TendCropsGoal farm = new TendCropsGoal(this);
    private MobAttackExt.TargetPosition targetPosition;
    private BlockPos seedInventory;
    private BlockPos cropInventory;
    public final Predicate<LivingEntity> hitPred = e -> {
        if (e != this) {
            if (this.m_20363_((Entity)e) || !e.m_142066_()) {
                return false;
            }
            if (e instanceof Mob && this == ((Mob)e).m_5448_()) {
                return true;
            }
            Entity controller = this.m_6688_();
            if (this.isTamed()) {
                UUID owner = EntityUtils.tryGetOwner(e);
                if (owner != null && (!this.attackOtherTamedMobs() || owner.equals(this.m_142504_()))) {
                    return false;
                }
                if (e == this.m_5448_()) {
                    return true;
                }
                if (controller instanceof Player) {
                    return true;
                }
                return e instanceof Enemy || e instanceof Mob && ((Mob)e).m_5448_() == this;
            }
            boolean riderTarget = false;
            if (controller != null) {
                Mob mob;
                if (controller instanceof BaseMonster) {
                    BaseMonster baseMonster = (BaseMonster)controller;
                    return baseMonster.hitPred.test((LivingEntity)e);
                }
                riderTarget = controller instanceof Mob && e == (mob = (Mob)controller).m_5448_();
            }
            return riderTarget || e == this.m_5448_() || EntityUtils.canMonsterTargetNPC((Entity)e) || EntityUtils.canAttackOwned(e, false, false, this.targetPred) || e instanceof Player;
        }
        return false;
    };
    private int playDeathTick;
    private final LevelExpPair levelPair = new LevelExpPair();
    protected int tamingTick = -1;
    private int brushCount;
    private int loveAttCount;
    private Runnable delayedTaming;
    protected int feedTimeOut;
    private boolean doJumping = false;
    private int foodBuffTick;
    private Player owner;
    private int tpCooldown;
    private Behaviour behaviour = Behaviour.WANDER;
    private final LevelExpPair friendlyPoints = new LevelExpPair();
    private final DailyMonsterUpdater updater = new DailyMonsterUpdater(this);
    private BarnData assignedBarn;
    private int moveTick;
    public static final int MOVE_TICK_MAX = 3;
    private boolean initAnim;

    public BaseMonster(EntityType<? extends BaseMonster> type, Level level) {
        super(type, level);
        this.f_21342_ = new MoveControlerEx((Mob)this);
        this.prop = DataPackHandler.INSTANCE.monsterPropertiesManager().getPropertiesFor(type);
        this.applyAttributes();
        if (!level.f_46443_) {
            this.addGoal();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder map = Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22278_, 1.0);
        for (RegistryEntrySupplier<Attribute> att : ModAttributes.ENTITY_ATTRIBUTES) {
            map.m_22266_((Attribute)att.get());
        }
        return map;
    }

    protected void applyAttributes() {
        for (Map.Entry<Attribute, Double> att : this.prop.getBaseValues().entrySet()) {
            AttributeInstance inst = this.m_21051_(att.getKey());
            if (inst == null) continue;
            inst.m_22100_(att.getValue().doubleValue());
            if (att.getKey() != Attributes.f_22276_) continue;
            this.m_21153_(this.m_21233_());
        }
    }

    public void addGoal() {
        this.f_21346_.m_25352_(1, this.targetPlayer);
        this.f_21346_.m_25352_(2, this.targetMobs);
        this.f_21346_.m_25352_(0, (Goal)this.hurt);
        this.f_21346_.m_25352_(3, (Goal)new RiderAttackTargetGoal((Mob)this, 15));
        this.f_21345_.m_25352_(0, (Goal)this.swimGoal);
        this.f_21345_.m_25352_(0, new StayGoal<BaseMonster>(this, StayGoal.CANSTAYMONSTER));
        this.f_21345_.m_25352_(1, (Goal)this.followOwnerGoal);
        this.f_21345_.m_25352_(2, (Goal)new LookAtAliveGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)this.wander);
        this.f_21345_.m_25352_(7, (Goal)new RandomLookGoalAlive((Mob)this));
    }

    protected void m_8022_() {
        boolean flag1 = !(this.m_20202_() instanceof Boat);
        this.f_21345_.m_25360_(Goal.Flag.MOVE, true);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, flag1);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
    }

    private void updateAI(boolean forced, boolean load) {
        if (forced || this.isTamed()) {
            this.m_21573_().m_26573_();
            if (this.behaviourState() != Behaviour.FARM) {
                this.seedInventory = null;
                this.cropInventory = null;
                if (this.behaviourState() != Behaviour.STAY) {
                    this.f_21346_.m_25352_(1, this.targetPlayer);
                    this.f_21346_.m_25352_(2, this.targetMobs);
                    this.f_21346_.m_25352_(0, (Goal)this.hurt);
                }
                this.f_21345_.m_25363_((Goal)this.farm);
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    FarmlandHandler.get(serverLevel.m_142572_()).removeIrrigationPOI(serverLevel, this.m_142081_());
                }
            }
            this.wander.m_25746_(120);
            switch (this.behaviourState()) {
                case WANDER_HOME: {
                    if (this.getOwner() == null) break;
                    if (this.findNearestBarn(load)) {
                        this.restrictToBasedOnBehaviour(null, load);
                        BlockPos pos = this.assignedBarn.pos.m_122646_();
                        if (this.f_19853_.m_46472_() == this.assignedBarn.pos.m_122640_()) {
                            TeleportSpell.safeTeleportTo((Entity)this, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        } else {
                            ServerLevel serverLevel = this.m_20194_().m_129880_(this.assignedBarn.pos.m_122640_());
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((Entity)this, serverLevel, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                            }
                        }
                    } else {
                        if (this.f_19797_ > 20) {
                            this.getOwner().m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.barn.no.ext", new Object[]{this.m_5446_(), this.m_142538_().m_123344_()}), Util.f_137441_);
                        }
                        this.setBehaviour(Behaviour.WANDER);
                    }
                    this.f_21345_.m_25352_(6, (Goal)this.wander);
                    this.wander.m_25746_(40);
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((Entity)this));
                    break;
                }
                case FOLLOW: {
                    boolean party;
                    boolean bl = party = this.getOwner() == null || Platform.INSTANCE.getPlayerData(this.getOwner()).map(d -> !d.party.isPartyFull() || d.party.isPartyMember((Entity)this)).orElse(false) != false;
                    if (!party) break;
                    this.m_147271_();
                    this.f_21345_.m_25363_((Goal)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((Entity)this));
                    break;
                }
                case FOLLOW_DISTANCE: {
                    this.m_147271_();
                    this.f_21345_.m_25363_((Goal)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((Entity)this));
                    break;
                }
                case STAY: {
                    this.f_21345_.m_25352_(6, (Goal)this.wander);
                    this.f_21346_.m_25363_(this.targetPlayer);
                    this.f_21346_.m_25363_(this.targetMobs);
                    this.f_21346_.m_25363_((Goal)this.hurt);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.addPartyMember((Entity)this));
                    break;
                }
                case WANDER: {
                    this.restrictToBasedOnBehaviour(this.m_142538_(), load);
                    this.f_21345_.m_25352_(6, (Goal)this.wander);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((Entity)this));
                    break;
                }
                case FARM: {
                    this.restrictToBasedOnBehaviour(this.m_142538_(), load);
                    this.f_21345_.m_25352_(3, (Goal)this.farm);
                    this.f_21346_.m_25363_(this.targetPlayer);
                    this.f_21346_.m_25363_(this.targetMobs);
                    this.f_21346_.m_25363_((Goal)this.hurt);
                    this.f_21345_.m_25363_((Goal)this.wander);
                    BlockPos nearestInv = this.nearestBlockEntityWithInv();
                    this.setSeedInventory(nearestInv);
                    this.setCropInventory(nearestInv);
                    if (this.getOwner() == null) break;
                    Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((Entity)this));
                }
            }
        }
    }

    public void restrictToBasedOnBehaviour(@Nullable BlockPos pos, boolean keepPos) {
        if (this.behaviourState() == Behaviour.WANDER_HOME && this.assignBarn() && this.f_19853_.m_46472_() == this.assignedBarn.pos.m_122640_()) {
            this.m_21446_(this.assignedBarn.pos.m_122646_(), this.assignedBarn.getSize() + 1);
        }
        if (pos == null) {
            return;
        }
        if (keepPos) {
            pos = this.m_21534_();
        }
        if (this.behaviourState() == Behaviour.FARM) {
            this.m_21446_(pos, MobConfig.farmRadius + 3);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                FarmlandHandler.get(serverLevel.m_142572_()).addIrrigationPOI(serverLevel, this.m_142081_(), this.m_142538_());
            }
        } else if (this.behaviourState() == Behaviour.WANDER) {
            this.m_21446_(pos, 9);
        }
    }

    private BlockPos nearestBlockEntityWithInv() {
        BlockPos blockPos = this.m_21534_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int radius = (int)this.m_21535_();
        for (int y = -1; y < 2; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    mutableBlockPos.m_122154_((Vec3i)blockPos, x, y, z);
                    if (!Platform.INSTANCE.matchingInventory(this.f_19853_.m_7702_((BlockPos)mutableBlockPos), s -> true)) continue;
                    return mutableBlockPos.m_7949_();
                }
            }
        }
        return null;
    }

    protected NearestAttackableTargetGoal<Player> createTargetGoalPlayer() {
        return new NearestAttackableTargetGoal((Mob)this, Player.class, 5, true, true, player -> !this.isTamed());
    }

    protected NearestAttackableTargetGoal<Mob> createTargetGoalMobs() {
        return new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, this.targetPred);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(MOVE_FLAGS, (Object)0);
        this.f_19804_.m_135372_(BEHAVIOUR_DATA, (Object)0);
        this.f_19804_.m_135372_(PLAY_DEATH_STATE, (Object)false);
        this.f_19804_.m_135372_(FRIEND_POINTS_SYNC, (Object)1);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_) {
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.f_19804_.m_135370_(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(PLAY_DEATH_STATE) && ((Boolean)this.f_19804_.m_135370_(PLAY_DEATH_STATE)).booleanValue() && !this.getAnimationHandler().hasAnimation()) {
                this.playDeathAnimation(true);
            }
        }
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.playTameEffect(true);
        } else if (id == 11) {
            this.playTameEffect(false);
        } else if (id == 34) {
            for (int i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_() - (double)this.m_20205_() * 0.25 + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 0.25f), this.m_20186_() + (double)this.m_20206_() + (double)this.f_19796_.nextFloat() * 0.3, this.m_20189_() - (double)this.m_20205_() * 0.25 + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 0.25f), 0.0, 0.0, 0.0);
            }
        } else if (id == 64) {
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123758_, true, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.3, this.m_20189_(), 0.0, 0.0, 0.0);
        } else if (id == 65) {
            this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123750_, true, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.3, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        super.m_7822_(id);
    }

    public void m_8119_() {
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                if (anim != null) {
                    this.setupAttack((AnimatedAction)anim);
                }
                return false;
            });
            this.initAnim = true;
        }
        super.m_8119_();
        Vec3 lookDir = this.directionToLookAt();
        if (lookDir != null) {
            float[] yxRot = MathsHelper.YXRotFrom(lookDir);
            float[] clamp = this.targetLookClamp();
            this.m_146922_(MathsHelper.rotlerp(this.m_146908_(), yxRot[0], clamp[0]));
            this.m_146926_(MathsHelper.rotlerp(this.m_146909_(), yxRot[1], clamp[1]));
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
        }
        this.moveTick = this.getMoveFlag() != MoveType.NONE ? Math.min(3, ++this.moveTick) : Math.max(0, --this.moveTick);
        if (!this.f_19853_.f_46443_) {
            this.updater.tick();
            if (this.tamingTick > 0 || this.m_21525_()) {
                if (this.getMoveFlag() != MoveType.NONE) {
                    this.setMovingFlag(MoveType.NONE);
                    this.m_20256_(Vec3.f_82478_);
                }
                if (this.tamingTick > 0) {
                    --this.tamingTick;
                }
            }
            if (this.tamingTick == 0) {
                if (this.delayedTaming != null) {
                    this.delayedTaming.run();
                    this.delayedTaming = null;
                }
                this.tamingTick = -1;
            }
            if (this.feedTimeOut > 0) {
                --this.feedTimeOut;
            }
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            if (this.assignedBarn != null && this.assignedBarn.isInvalidFor(this)) {
                this.assignedBarn = null;
            }
            if (this.isTamed() && this.assignedBarn == null && MobConfig.monsterNeedBarn && this.behaviourState() != Behaviour.STAY) {
                this.setBehaviour(Behaviour.STAY);
            }
            this.handleTestingTick();
        } else if (!this.playDeath() && TendCropsGoal.cantTendToCropsAnymore(this) && this.behaviour == Behaviour.FARM && this.f_19797_ % 20 == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123792_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 0.3, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.getAnimationHandler().getAnimation() == null) {
            this.targetPosition = null;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.getAnimationHandler().tick();
        boolean teleported = false;
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            Player owner;
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (owner = this.getOwner()) != null) {
                serverLevel.m_7726_().m_8387_(WorldUtils.ENTITY_LOADER, this.m_146902_(), 3, (Object)this.m_146902_());
                if (owner.f_19853_.m_46472_() != this.f_19853_.m_46472_()) {
                    TeleportUtils.safeDimensionTeleport((Mob)this, (ServerLevel)owner.f_19853_, owner.m_142538_());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (owner.m_20280_((Entity)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((Mob)this, (Entity)owner);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
        }
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.f_19853_.f_46443_) {
                if (teleported) {
                    this.m_5634_(1.0f);
                }
                if ((double)this.m_21223_() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("MobLevel", (Tag)this.level().save());
        if (this.isTamed()) {
            compound.m_128362_("Owner", this.m_142504_());
        }
        compound.m_128405_("Behaviour", this.behaviourState().ordinal());
        compound.m_128405_("FeedTime", this.feedTimeOut);
        if (this.m_21536_()) {
            compound.m_128385_("Home", new int[]{this.m_21534_().m_123341_(), this.m_21534_().m_123342_(), this.m_21534_().m_123343_(), (int)this.m_21535_()});
        }
        compound.m_128405_("FoodBuffTick", this.foodBuffTick);
        compound.m_128365_("FriendlyPoints", (Tag)this.friendlyPoints.save());
        compound.m_128365_("DailyUpdater", (Tag)this.updater.save());
        compound.m_128379_("PlayDeath", ((Boolean)this.f_19804_.m_135370_(PLAY_DEATH_STATE)).booleanValue());
        if (this.seedInventory != null) {
            compound.m_128385_("SeedInventory", new int[]{this.seedInventory.m_123341_(), this.seedInventory.m_123342_(), this.seedInventory.m_123343_()});
        }
        if (this.cropInventory != null) {
            compound.m_128385_("CropInventory", new int[]{this.cropInventory.m_123341_(), this.cropInventory.m_123342_(), this.cropInventory.m_123343_()});
        }
        if (this.assignedBarn != null && !this.assignedBarn.isInvalidFor(this)) {
            GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.assignedBarn.pos).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(t -> compound.m_128365_("AssignedBarnLocation", t));
        }
    }

    public void m_7378_(CompoundTag compound) {
        int[] arr;
        super.m_7378_(compound);
        this.levelPair.read((Tag)compound.m_128469_("MobLevel"));
        if (compound.m_128441_("Owner")) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(compound.m_128342_("Owner")));
        }
        this.feedTimeOut = compound.m_128451_("FeedTime");
        if (compound.m_128441_("Home")) {
            int[] home = compound.m_128465_("Home");
            this.m_21446_(new BlockPos(home[0], home[1], home[2]), home[3]);
        }
        this.foodBuffTick = compound.m_128451_("FoodBuffTick");
        this.friendlyPoints.read((Tag)compound.m_128469_("FriendlyPoints"));
        this.f_19804_.m_135381_(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel());
        this.updater.read(compound.m_128469_("DailyUpdater"));
        this.setPlayDeath(compound.m_128471_("PlayDeath"));
        if (compound.m_128441_("SeedInventory") && (arr = compound.m_128465_("SeedInventory")).length == 3) {
            this.seedInventory = new BlockPos(arr[0], arr[1], arr[2]);
        }
        if (compound.m_128441_("CropInventory") && (arr = compound.m_128465_("CropInventory")).length == 3) {
            this.cropInventory = new BlockPos(arr[0], arr[1], arr[2]);
        }
        if (compound.m_128441_("AssignedBarnLocation") && this.m_20194_() != null) {
            GlobalPos.f_122633_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)compound.m_128423_("AssignedBarnLocation"))).resultOrPartial(arg_0 -> ((Logger)RuneCraftory.LOGGER).error(arg_0)).ifPresent(p -> {
                this.assignedBarn = WorldHandler.get(this.m_20194_()).barnAt((GlobalPos)p);
            });
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.m_128451_("Behaviour")], true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return !this.isTamed();
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.isTamed();
    }

    public void m_8024_() {
        super.m_8024_();
        if (!this.m_5807_() && this.m_21566_().f_24981_ != MoveControl.Operation.WAIT && this.m_20184_().m_82556_() > 0.004) {
            double d0 = this.m_21566_().m_24999_();
            MoveType move = d0 > this.sprintSpeedThreshold() ? MoveType.RUN : (d0 <= this.crouchSpeedThreshold() ? MoveType.SNEAK : MoveType.WALK);
            if (this.m_6107_()) {
                move = MoveType.NONE;
            }
            this.setMovingFlag(move);
            this.updateMoveAnimation();
        } else {
            this.setMovingFlag(MoveType.NONE);
            this.m_20260_(false);
            this.m_6858_(false);
        }
    }

    public double crouchSpeedThreshold() {
        return 0.6;
    }

    public double sprintSpeedThreshold() {
        return 1.0;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.m_6851_(difficulty);
        this.setLevel(Mth.m_14045_((int)this.level().getLevel(), (int)this.prop.minLevel, (int)10000));
        return spawnData;
    }

    public boolean m_5807_() {
        return this.isTamed() && this.rideable() && this.m_6688_() instanceof Player;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        boolean clientSide = this.f_19853_.f_46443_;
        ItemStack stack = player.m_21120_(hand);
        if (this.isTamed()) {
            if (!player.m_142081_().equals(this.m_142504_())) {
                if (!clientSide) {
                    player.m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.notowner"), Util.f_137441_);
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
            if (player.m_6144_() && stack.m_41720_() == Items.f_42398_) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12507_, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f));
                    this.untameEntity();
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
            if (!clientSide && MobConfig.monsterNeedBarn && this.assignedBarn == null && !this.assignBarn()) {
                player.m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.barn.no", new Object[]{this.m_5446_()}), Util.f_137441_);
                return InteractionResult.CONSUME;
            }
            if (stack.m_41720_() == ModItems.BRUSH.get()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int day = WorldUtils.day(this.f_19853_);
                    if (this.updater.getLastUpdateBrush() == day) {
                        return InteractionResult.PASS;
                    }
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12034_, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.7f, 1.0f));
                    this.updater.setLastUpdateBrush(day);
                    this.onBrushing();
                    this.increaseFriendPoints(15);
                    this.f_19853_.m_7605_((Entity)this, (byte)64);
                    player.m_6674_(hand);
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
            if (hand == InteractionHand.MAIN_HAND && !this.playDeath() && player.m_6144_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EntityUtils.sendAttributesTo((LivingEntity)this, serverPlayer);
                    Platform.INSTANCE.sendToClient(new S2COpenCompanionGui(this, serverPlayer), serverPlayer);
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && !stack.m_41619_()) {
            if (stack.m_41720_() == ModItems.TAME.get()) {
                if (!clientSide) {
                    this.tameEntity(player);
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
            if (stack.m_41720_() == ModItems.BRUSH.get() && this.m_6084_()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (this.tamingTick == -1) {
                        return InteractionResult.PASS;
                    }
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SoundEvents.f_12034_, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.7f, 1.0f));
                    this.brushCount = Math.min(10, this.brushCount + 1);
                    this.tamingTick = 40;
                    this.f_19853_.m_7605_((Entity)this, (byte)64);
                }
                return InteractionResult.m_19078_((boolean)clientSide);
            }
        }
        return InteractionResult.PASS;
    }

    public void increaseFriendPoints(int xp) {
        boolean leveledUp = this.friendlyPoints.addXP(xp, 10, LevelCalc::friendPointsForNext, () -> this.f_19804_.m_135381_(FRIEND_POINTS_SYNC, (Object)this.friendlyPoints.getLevel()));
        if (leveledUp) {
            this.updateFriendPointAttributeBonus();
        }
    }

    private void updateFriendPointAttributeBonus() {
        List<Attribute> increasable = List.of(Attributes.f_22276_, Attributes.f_22281_, (Attribute)ModAttributes.DEFENCE.get(), (Attribute)ModAttributes.MAGIC.get(), (Attribute)ModAttributes.MAGIC_DEFENCE.get());
        for (Attribute att : increasable) {
            AttributeInstance inst = this.m_21051_(att);
            if (inst == null) continue;
            double inc = (double)(this.friendlyPoints.getLevel() - 1) * 0.03;
            inst.m_22120_(LibConstants.ATTRIBUTE_FRIEND_MOD);
            inst.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_FRIEND_MOD, "rf.friend.mod", inc, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void onBrushing() {
        Attribute toIncrease = switch (this.f_19796_.nextInt(4)) {
            case 1 -> (Attribute)ModAttributes.DEFENCE.get();
            case 2 -> (Attribute)ModAttributes.MAGIC.get();
            case 3 -> (Attribute)ModAttributes.MAGIC_DEFENCE.get();
            default -> Attributes.f_22281_;
        };
        AttributeInstance inst = this.m_21051_(toIncrease);
        if (inst != null) {
            AttributeModifier mod = inst.m_22111_(LibConstants.ATTRIBUTE_BRUSH_MOD);
            double inc = 1.0;
            if (mod != null) {
                inc += mod.m_22218_();
            }
            inst.m_22120_(LibConstants.ATTRIBUTE_BRUSH_MOD);
            inst.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_BRUSH_MOD, "rf.brush.mod", inc, AttributeModifier.Operation.ADDITION));
        }
    }

    public boolean m_6109_() {
        return this.m_5807_() && !this.f_19853_.f_46443_;
    }

    public boolean m_7327_(Entity entity) {
        return CombatUtils.mobAttack((LivingEntity)this, entity, this.damageSourceAttack());
    }

    public CustomDamage.Builder damageSourceAttack() {
        return new CustomDamage.Builder((Entity)this).hurtResistant(5);
    }

    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.m_21187_().nextInt(20) + 25 + diffAdd;
        }
        return this.m_21187_().nextInt(20) + 15 + diffAdd;
    }

    public int difficultyCooldown() {
        int diffAdd = 12;
        Difficulty diff = this.f_19853_.m_46791_();
        if (this.f_19853_.m_46791_() == Difficulty.HARD) {
            diffAdd = 0;
        } else if (diff == Difficulty.NORMAL) {
            diffAdd = 7;
        }
        return diffAdd;
    }

    @Override
    public TagKey<Item> tamingItem() {
        return RunecraftoryTags.tamingTag(this.m_6095_());
    }

    public ResourceLocation dailyDropTable() {
        ResourceLocation def = this.m_7582_();
        return new ResourceLocation(def.m_135827_(), def.m_135815_() + "_tamed_drops");
    }

    @Override
    public float tamingChance() {
        return this.prop.tamingChance;
    }

    @Override
    public boolean isTamed() {
        return this.m_142504_() != null;
    }

    @Override
    public boolean rideable() {
        return this.prop.rideable;
    }

    public boolean attackOtherTamedMobs() {
        return false;
    }

    public EntityProperties getProp() {
        return this.prop;
    }

    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public Player getOwner() {
        UUID uuid = this.m_142504_();
        if (uuid != null) {
            if (this.owner == null || !this.owner.m_6084_()) {
                this.owner = this.f_19853_.f_46443_ ? this.f_19853_.m_46003_(uuid) : this.f_19853_.m_142572_().m_6846_().m_11259_(uuid);
            }
        } else {
            this.owner = null;
        }
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        if (player != null) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(player.m_142081_()));
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        }
    }

    @Override
    public boolean isFlyingEntity() {
        return this.prop.flying;
    }

    @Override
    public LevelExpPair level() {
        return this.levelPair;
    }

    @Override
    public void setLevel(int level) {
        this.levelPair.setLevel(Mth.m_14045_((int)level, (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void m_6457_(ServerPlayer player) {
        Platform.INSTANCE.sendToClient(S2CEntityLevelPkt.create(this), player);
    }

    @Override
    public int baseXP() {
        return this.prop.xp;
    }

    @Override
    public int baseMoney() {
        return this.prop.money;
    }

    @Override
    public boolean applyFoodEffect(ItemStack stack) {
        io.github.flemmli97.runecraftory.api.datapack.FoodProperties food;
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (stack.m_41720_() == ModItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((LivingEntity)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.m_41720_())) == null) {
            FoodProperties mcFood = stack.m_41720_().m_41473_();
            this.m_5584_(this.f_19853_, stack);
            if (mcFood != null) {
                this.m_5634_((float)mcFood.m_38744_() * 0.5f);
                return true;
            }
            return false;
        }
        this.m_5584_(this.f_19853_, stack);
        Pair<Map<Attribute, Double>, Map<Attribute, Double>> foodStats = ItemNBT.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            AttributeInstance inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.m_21051_((Attribute)entry.getKey());
                if (inst == null) continue;
                inst.m_22120_(LibConstants.FOOD_UUID_MULTI);
                inst.m_22125_(new AttributeModifier(LibConstants.FOOD_UUID_MULTI, "foodBuffMulti_" + ((Attribute)entry.getKey()).m_22087_(), ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.MULTIPLY_BASE));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.m_21051_((Attribute)entry.getKey());
                if (inst == null) continue;
                inst.m_22120_(LibConstants.FOOD_UUID);
                inst.m_22125_(new AttributeModifier(LibConstants.FOOD_UUID, "foodBuff_" + ((Attribute)entry.getKey()).m_22087_(), ((Double)entry.getValue()).doubleValue(), AttributeModifier.Operation.ADDITION));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((LivingEntity)this, food.getHPGain());
        EntityUtils.foodHealing((LivingEntity)this, this.m_21233_() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (MobEffect mobEffect : food.potionHeals()) {
                this.m_21195_(mobEffect);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.m_7292_(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.m_21204_()).getAttributes().values().forEach(inst -> {
            inst.m_22120_(LibConstants.FOOD_UUID);
            inst.m_22120_(LibConstants.FOOD_UUID_MULTI);
        });
    }

    @Override
    public boolean onGivingItem(Player player, ItemStack stack) {
        if (this.isTamed()) {
            if (!player.m_142081_().equals(this.m_142504_())) {
                return false;
            }
            if (this.m_20363_((Entity)player)) {
                return false;
            }
            if (this.feedTimeOut <= 0) {
                boolean favorite = stack.m_204117_(this.tamingItem());
                int count = stack.m_41613_();
                SoundEvent sound = switch (stack.m_41780_()) {
                    case UseAnim.DRINK -> stack.m_41615_();
                    case UseAnim.EAT -> stack.m_41616_();
                    default -> SoundEvents.f_12216_;
                };
                boolean food = this.applyFoodEffect(stack);
                if (food || !this.playDeath()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(sound, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.7f, 1.0f));
                        Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> data.getDailyUpdater().onGiveMonsterItem(serverPlayer));
                    }
                    stack.m_41764_(count);
                    this.feedTimeOut = 7;
                    int day = WorldUtils.day(this.f_19853_);
                    if (this.updater.getLastUpdateFood() != day) {
                        this.updater.setLastUpdateFood(day);
                        this.increaseFriendPoints(favorite ? 50 : 30);
                        if (favorite) {
                            this.f_19853_.m_7605_((Entity)this, (byte)65);
                        } else {
                            this.f_19853_.m_7605_((Entity)this, (byte)64);
                        }
                        DataPackHandler.INSTANCE.itemStatManager().get(stack.m_41720_()).ifPresent(s -> s.getMonsterGiftIncrease().forEach((att, d) -> {
                            AttributeInstance inst = this.m_21051_((Attribute)att);
                            if (inst != null) {
                                AttributeModifier mod = inst.m_22111_(LibConstants.MONSTER_ITEM_BONUS);
                                double val = d;
                                if (mod != null) {
                                    val += mod.m_22218_();
                                    inst.m_22130_(mod);
                                }
                                inst.m_22125_(new AttributeModifier(LibConstants.MONSTER_ITEM_BONUS, "item_bonus_" + att.m_22087_(), val, AttributeModifier.Operation.ADDITION));
                            }
                        }));
                    }
                    stack.m_41774_(1);
                }
                return true;
            }
        } else if (this.tamingTick == -1 && this.m_6084_()) {
            SoundEvent sound;
            switch (stack.m_41780_()) {
                case DRINK: {
                    SoundEvent soundEvent = stack.m_41615_();
                    break;
                }
                case EAT: {
                    SoundEvent soundEvent = stack.m_41616_();
                    break;
                }
                default: {
                    SoundEvent soundEvent = sound = SoundEvents.f_12216_;
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(sound, SoundSource.NEUTRAL, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.7f, 1.0f));
            }
            float rightItemMultiplier = this.tamingMultiplier(stack);
            int count = stack.m_41613_();
            this.applyFoodEffect(stack);
            if (count == stack.m_41613_() && !player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.tamingTick = 60;
            float chance = EntityUtils.tamingChance(this, player, rightItemMultiplier, this.brushCount, this.loveAttCount);
            if (!(this.m_20194_() == null || MobConfig.monsterNeedBarn && WorldHandler.get(this.m_20194_()).findFittingBarn(this, player.m_142081_()) == null)) {
                this.delayedTaming = () -> {
                    if (chance == 0.0f) {
                        this.f_19853_.m_7605_((Entity)this, (byte)34);
                    } else if (this.f_19796_.nextFloat() < chance) {
                        this.tameEntity(player);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)11);
                    }
                };
            }
            return true;
        }
        return false;
    }

    public void recalcStatsFull() {
        this.applyAttributes();
        this.updateStatsToLevel();
        this.updateFriendPointAttributeBonus();
    }

    public void updateStatsToLevel() {
        if (!this.f_19853_.f_46443_) {
            Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (Entity)this);
        }
        float preHealthDiff = this.m_21233_() - this.m_21223_();
        this.prop.getAttributeGains().forEach((att, val) -> {
            AttributeInstance inst = this.m_21051_((Attribute)att);
            if (inst != null) {
                val = val * 0.01;
                inst.m_22120_(LibConstants.ATTRIBUTE_LEVEL_MOD);
                float multiplier = 1.0f;
                multiplier = att == Attributes.f_22276_ ? (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.15f) * 0.02f) : (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.0f) * 0.015f);
                inst.m_22125_(new AttributeModifier(LibConstants.ATTRIBUTE_LEVEL_MOD, "rf.levelMod", (double)(this.level().getLevel() - 1) * val * (double)multiplier, AttributeModifier.Operation.ADDITION));
                if (att == Attributes.f_22276_) {
                    this.m_21153_(this.m_21233_() - preHealthDiff);
                }
            }
        });
    }

    public void increaseLevel() {
        this.levelPair.setLevel(Mth.m_14045_((int)(this.level().getLevel() + 1), (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        LevelExpPair pair = this.level();
        boolean res = pair.addXP(amount, 10000, LevelCalc::xpAmountForLevelUp, () -> {});
        Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (Entity)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateMoveAnimation() {
    }

    public LevelExpPair getFriendlyPoints() {
        return this.friendlyPoints;
    }

    @Override
    public int friendPoints(UUID player) {
        if (player.equals(this.m_142504_())) {
            return (Integer)this.f_19804_.m_135370_(FRIEND_POINTS_SYNC);
        }
        return 0;
    }

    public void onDailyUpdate() {
        if (this.f_19853_ instanceof ServerLevel && this.isTamed() && !this.playDeath() && (!MobConfig.monsterNeedBarn || this.assignBarn())) {
            ResourceLocation resourceLocation = this.dailyDropTable();
            this.dropAsDailyDrop(resourceLocation);
        }
    }

    protected void dropAsDailyDrop(ResourceLocation resourceLocation) {
        LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(resourceLocation);
        lootTable.m_79148_(this.dailyDropContext().m_78975_(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((BaseMonster)this).m_19983_(arg_0));
    }

    protected LootContext.Builder dailyDropContext() {
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, (Object)this).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_());
        if (this.m_142504_() != null) {
            builder.m_78984_(LootCtxParameters.UUID_CONTEXT, (Object)this.m_142504_());
        }
        return builder;
    }

    public int moveTick() {
        return this.moveTick;
    }

    public float interpolatedMoveTick(float partialTicks) {
        return Mth.m_14036_((float)(((float)this.moveTick + (this.getMoveFlag() != MoveType.NONE ? partialTicks : -partialTicks)) / 3.0f), (float)0.0f, (float)1.0f);
    }

    public void setMovingFlag(MoveType type) {
        this.f_19804_.m_135381_(MOVE_FLAGS, (Object)((byte)type.ordinal()));
    }

    public MoveType getMoveFlag() {
        return MoveType.values()[(Byte)this.f_19804_.m_135370_(MOVE_FLAGS)];
    }

    public void setDoJumping(boolean jump) {
        this.doJumping = jump;
    }

    public boolean doJumping() {
        return this.doJumping;
    }

    private void playTameEffect(boolean play) {
        SimpleParticleType particle = ParticleTypes.f_123750_;
        int amount = 13;
        if (!play) {
            particle = ParticleTypes.f_123762_;
            amount += 9;
        }
        for (int i = 0; i < amount; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            double d3 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_6493_((ParticleOptions)particle, true, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + 0.5 + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d2, d3);
        }
    }

    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_) {
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
                this.getOwner().m_6352_(this.m_21231_().m_19293_(), Util.f_137441_);
            }
            if (this.m_20194_() != null && this.m_142504_() != null) {
                WorldHandler.get(this.m_20194_()).removeMonsterFromPlayer(this.m_142504_(), this);
                this.assignedBarn = null;
            }
            this.getAnimationHandler().setAnimation(null);
            List<CombatEntry> entries = ((CombatTrackerAccessor)this.m_21231_()).getEntries();
            HashMap merged = new HashMap();
            entries.forEach(e -> {
                Entity patt57349$temp = e.m_146687_();
                if (patt57349$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt57349$temp;
                    merged.compute(player.m_142081_(), (id, o) -> o == null ? new CombatRecord(player, e.m_19263_(), e.m_19264_()) : new CombatRecord(player, e.m_19263_(), o.totalDamage() + e.m_19264_()));
                }
            });
            merged.values().forEach(rec -> this.onDeathDamageRecord(rec.player, rec.lastSource, rec.totalDamage));
        }
        super.m_6667_(cause);
    }

    public void onDeathDamageRecord(ServerPlayer player, DamageSource source, float damage) {
        if ((double)damage > (double)this.m_21233_() * 0.05) {
            Platform.INSTANCE.getPlayerData((Player)player).ifPresent(d -> d.increaseMobFrom(player, this));
        }
    }

    protected void m_6153_() {
        if (!this.f_19853_.f_46443_ && this.f_20919_ == 0) {
            this.playDeathAnimation(false);
            this.m_21573_().m_26573_();
        }
        ++this.f_20919_;
        if (this.f_20919_ == this.maxDeathTime() - 5 && !this.f_19853_.f_46443_ && this.m_142581_() != null) {
            LevelCalc.addXP(this.m_142581_(), this.baseXP(), this.baseMoney(), this.level().getLevel());
        }
        if (this.f_20919_ >= this.maxDeathTime()) {
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
        }
    }

    public void m_6703_(@Nullable LivingEntity livingBase) {
        if (this.m_21224_() && this.f_20919_ > 0) {
            return;
        }
        super.m_6703_(livingBase);
    }

    public boolean playDeath() {
        return (Boolean)this.f_19804_.m_135370_(PLAY_DEATH_STATE);
    }

    public void setPlayDeath(boolean flag) {
        this.f_19804_.m_135381_(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
                this.getOwner().m_6352_(this.getKnockoutMessage(), Util.f_137441_);
            }
            this.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), this.m_142469_().m_82400_(32.0), e -> this.equals(e.m_5448_())).forEach(m -> m.m_6710_(null));
            this.m_21573_().m_26573_();
            this.playDeathAnimation(false);
            this.setMovingFlag(MoveType.NONE);
            this.m_20260_(false);
            this.m_6858_(false);
            this.m_19877_();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private Component getKnockoutMessage() {
        DamageSource source = this.m_21225_();
        if (source instanceof EntityDamageSource && source.m_7639_() != null) {
            return new TranslatableComponent("runecraftory.tamed.monster.knockout.by", new Object[]{this.m_5446_(), this.m_142538_().m_123341_(), this.m_142538_().m_123342_(), this.m_142538_().m_123343_(), source.m_7639_().m_5446_()});
        }
        return new TranslatableComponent("runecraftory.tamed.monster.knockout", new Object[]{this.m_5446_(), this.m_142538_().m_123341_(), this.m_142538_().m_123342_(), this.m_142538_().m_123343_()});
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public boolean m_142066_() {
        return super.m_142066_() && !this.playDeath();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_142081_().equals(this.m_142504_()) && !player.m_6144_()) {
            return false;
        }
        if (this.playDeath() && source != DamageSource.f_19317_) {
            return false;
        }
        return (source.m_7639_() == null || this.canAttackFrom(source.m_7639_().m_20182_())) && super.m_6469_(source, amount);
    }

    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        CustomDamage dmg;
        super.m_6475_(damageSrc, damageAmount);
        if (!this.isTamed() && damageSrc instanceof CustomDamage && (dmg = (CustomDamage)damageSrc).m_7639_() instanceof Player && dmg.getElement() == EnumElement.LOVE) {
            this.loveAttCount = Math.min(100, this.loveAttCount + 1);
        }
        if (damageSrc != DamageSource.f_19317_ && this.isTamed() && this.m_21223_() <= 0.0f) {
            this.m_21153_(0.01f);
            this.setPlayDeath(true);
        }
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        if (this.isFlyingEntity() || this.m_21566_() instanceof FlyingMoveControl) {
            return false;
        }
        return super.m_142535_(fallDistance, multiplier, source);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.m_5807_() || this.playDeath() || this.tamingTick > 0;
    }

    protected float m_6108_() {
        return 0.83f;
    }

    public void m_7332_(Entity passenger) {
        if (this.m_20363_(passenger)) {
            Vec3 offset = this.passengerOffset(passenger).m_82520_(0.0, passenger.m_6049_(), 0.0).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            passenger.m_6034_(this.m_20185_() + offset.m_7096_(), this.m_20186_() + offset.m_7098_(), this.m_20189_() + offset.m_7094_());
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                living.f_20883_ = this.f_20883_;
            }
        }
    }

    public Vec3 passengerOffset(Entity passenger) {
        return new Vec3(0.0, this.m_6048_(), 0.0);
    }

    public void m_7023_(Vec3 vec) {
        Entity entity;
        if (this.shouldFreezeTravel()) {
            this.f_20900_ = 0.0f;
            this.f_20901_ = 0.0f;
            this.f_20902_ = 0.0f;
            return;
        }
        if (this.m_5807_() && (entity = this.m_6688_()) instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerInput(player, this.m_20068_(), this::handleLandTravel);
        } else {
            this.handleLandTravel(vec);
        }
    }

    public void handleLandTravel(Vec3 vec) {
        this.f_20887_ = 0.02f;
        if (!this.m_6084_() || this.playDeath()) {
            vec = Vec3.f_82478_;
        }
        super.m_7023_(vec);
    }

    public void handleFreeTravel(Vec3 vec) {
        Entity entity;
        if (this.shouldFreezeTravel()) {
            this.f_20900_ = 0.0f;
            this.f_20901_ = 0.0f;
            this.f_20902_ = 0.0f;
            return;
        }
        if (this.m_5807_() && (entity = this.m_6688_()) instanceof Player) {
            Player player = (Player)entity;
            this.handlePlayerInput(player, true, this::freeTravel);
        } else {
            this.freeTravel(vec);
        }
    }

    private void freeTravel(Vec3 vec) {
        boolean currentNophysics = this.f_19794_;
        if (!this.m_6084_() || this.playDeath()) {
            this.f_19794_ = false;
            vec = Vec3.f_82478_;
        }
        this.m_19920_(this.m_6113_() * 0.2f, vec);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.91));
        this.f_19794_ = currentNophysics;
    }

    protected void handlePlayerInput(Player player, boolean hovers, Consumer<Vec3> cons) {
        if (this.getAnimationHandler().hasAnimation()) {
            this.setMovingFlag(MoveType.NONE);
            this.m_6858_(false);
            cons.accept(Vec3.f_82478_);
            this.m_21043_((LivingEntity)this, false);
            return;
        }
        if (!this.m_6109_()) {
            this.m_20256_(Vec3.f_82478_);
            this.setDoJumping(false);
            this.m_21043_((LivingEntity)this, false);
            return;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.adjustRotFromRider((LivingEntity)player)) {
                this.m_146922_(this.rotateClamped(this.m_146908_(), player.m_146908_(), this.m_21529_() * 2));
                this.m_146926_(this.rotateClamped(this.m_146909_(), player.m_146909_(), this.m_8132_()));
            }
            this.f_20885_ = this.f_20883_ = this.m_146908_();
        }
        double attrSpeed = !this.m_20096_() && this.m_21204_().m_22171_(Attributes.f_22280_) ? this.m_21133_(Attributes.f_22280_) : this.m_21133_(Attributes.f_22279_);
        float speed = (float)(attrSpeed / 1.3 * this.ridingSpeedModifier());
        float strafing = player.f_20900_ / 0.98f * speed * 0.8f;
        if (player.f_20900_ < 0.0f) {
            strafing *= -1.0f;
        }
        float forward = player.f_20902_ / 0.98f * speed;
        if (player.f_20902_ < 0.0f) {
            forward *= -0.5f;
        }
        float vertical = 0.0f;
        this.f_20887_ = speed * 0.2f;
        if (hovers && forward > 0.0f) {
            vertical = (float)Math.min(0.0, player.m_20154_().f_82480_ + 0.45) * speed;
            if (player.m_146909_() > 85.0f) {
                forward = 0.0f;
            } else if (vertical < 0.0f) {
                forward = (float)Math.sqrt(forward * forward - vertical * vertical);
            }
        }
        if (this.doJumping()) {
            if (this.f_19861_ && !this.isFlyingEntity()) {
                this.f_19812_ = true;
                this.m_6135_();
                if (forward > 0.0f) {
                    float x = -Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    float z = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                    this.m_20256_(this.m_20184_().m_82520_(0.3 * (double)x, 0.0, 0.3 * (double)z));
                }
            } else if (this.isFlyingEntity()) {
                vertical = speed * 0.7f;
                if (this.m_20184_().m_7098_() < (double)vertical) {
                    this.m_20256_(new Vec3(this.m_20184_().f_82479_, this.m_20184_().f_82480_ + 0.1, this.m_20184_().f_82481_));
                }
            }
        }
        this.m_7910_(speed);
        MoveType type = forward > 0.0f ? MoveType.RUN : (forward != 0.0f || strafing != 0.0f ? MoveType.WALK : MoveType.NONE);
        this.setMovingFlag(type);
        this.m_6858_(type == MoveType.RUN);
        cons.accept(new Vec3((double)strafing, (double)vertical, (double)forward));
        this.setDoJumping(false);
        this.m_21043_((LivingEntity)this, false);
    }

    private float rotateClamped(float current, float target, float maxChange) {
        float f = Mth.m_14118_((float)current, (float)target);
        float g = Mth.m_14036_((float)f, (float)(-maxChange), (float)maxChange);
        return current + g;
    }

    public double ridingSpeedModifier() {
        return 1.3;
    }

    public boolean shouldFreezeTravel() {
        return false;
    }

    public int maxDeathTime() {
        return 20;
    }

    protected void playDeathAnimation(boolean load) {
        if (this.getDeathAnimation() != null) {
            this.getAnimationHandler().setAnimation(this.getDeathAnimation());
            if (load && this.f_19853_.f_46443_) {
                AnimatedAction anim = this.getAnimationHandler().getAnimation();
                while (!anim.done(0)) {
                    anim.tick();
                }
            }
        }
    }

    public AnimatedAction getDeathAnimation() {
        return null;
    }

    public void m_21250_(BlockPos pos) {
        super.m_21250_(pos);
        this.setSleeping(true);
    }

    public void m_21258_() {
        super.m_21258_();
        this.setSleeping(false);
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.onSleeping(sleeping);
    }

    @Override
    public boolean hasSleepingAnimation() {
        return this.getSleepAnimation() != null;
    }

    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            if (this.getSleepAnimation() != null) {
                this.getAnimationHandler().setAnimation(this.getSleepAnimation());
                if (this.f_19803_ && this.f_19853_.f_46443_) {
                    AnimatedAction anim = this.getAnimationHandler().getAnimation();
                    while (!anim.done(0)) {
                        anim.tick();
                    }
                }
            }
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    public AnimatedAction getSleepAnimation() {
        return null;
    }

    private boolean canAttackFrom(Vec3 pos) {
        boolean result;
        if (this.isTamed()) {
            return true;
        }
        boolean bl = result = this.m_21535_() == -1.0f || this.m_21534_().m_203198_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_()) < (double)(this.m_21535_() * this.m_21535_());
        if (!result) {
            this.f_19853_.m_6269_(null, (Entity)this, SoundEvents.f_11669_, this.m_5720_(), 0.7f, 0.9f);
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 6; ++i) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20208_(1.2), this.m_20187_(), this.m_20262_(1.2), 0, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        return result;
    }

    public void setupAttack(AnimatedAction anim) {
        if (this.m_5448_() != null) {
            this.setTargetPosition(this.m_5448_());
        }
    }

    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{this.getDeathAnimation(), this.getSleepAnimation()})) {
            return;
        }
        this.m_21573_().m_26573_();
        if (anim.isAt("attack")) {
            this.mobAttack(anim, this.m_5448_(), this::m_7327_);
        }
    }

    protected Vec3 directionToLookAt() {
        return this.getAnimationHandler().hasAnimation() && this.targetPosition != null ? this.targetPosition.asVec(this.m_20182_()).m_82546_(this.m_20182_()) : null;
    }

    protected float[] targetLookClamp() {
        return new float[]{60.0f, 30.0f};
    }

    public void setTargetPosition(LivingEntity target) {
        this.setTargetPosition(MobAttackExt.TargetPosition.of(target));
    }

    public void setTargetPosition(MobAttackExt.TargetPosition position) {
        this.targetPosition = position;
        if (!this.f_19853_.f_46443_) {
            S2CMobUpdate.send(this, SyncableDatas.TARGET_POS, this.targetPosition);
        }
    }

    @Override
    public MobAttackExt.TargetPosition getTargetPosition() {
        return this.targetPosition;
    }

    @Nullable
    public Vec3 tryGetTargetPosition(LivingEntity target) {
        if (this.getTargetPosition() != null) {
            return this.getTargetPosition().asVec(this.m_20182_());
        }
        return target != null ? target.m_20182_() : null;
    }

    public void mobAttack(AnimatedAction anim, LivingEntity target, Consumer<LivingEntity> cons) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, this.tryGetTargetPosition(target), 0.0);
        this.f_19853_.m_6443_(LivingEntity.class, obb.getEncompassingBox(), entity -> this.hitPred.test((LivingEntity)entity) && obb.intersects(entity.m_142469_())).forEach(cons);
        if (!this.f_19853_.f_46443_) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (Entity)this);
        }
    }

    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, @Nullable Vec3 target, double grow) {
        float yRot = this.m_146908_();
        float xRot = this.m_146909_();
        if (target != null && !this.m_5807_()) {
            Vec3 dir = target.m_82546_(this.m_20182_()).m_82541_();
            float[] xYRot = MathsHelper.YXRotFrom(dir);
            yRot = xYRot[0];
            xRot = -xYRot[1];
        } else {
            Entity entity = this.m_6688_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                yRot = player.m_146908_();
                xRot = player.m_146909_();
            }
        }
        double off = (double)this.m_20206_() * 0.5;
        return new OrientedBoundingBox(this.attackBB(anim).m_82377_(grow, 0.0, grow).m_82386_(0.0, -off, grow), yRot, Mth.m_14036_((float)xRot, (float)-15.0f, (float)15.0f), this.m_20182_().m_82520_(0.0, off, 0.0));
    }

    public OrientedBoundingBox prepareAttackBox(AnimatedAction anim, LivingEntity target, double grow, boolean debug) {
        OrientedBoundingBox obb = this.calculateAttackAABB(anim, target.m_20182_(), grow);
        if (debug) {
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTEMPT, (Entity)this);
        }
        return obb;
    }

    public AABB attackBB(AnimatedAction anim) {
        double range = 1.0;
        return new AABB(-range * 0.5, -0.02, 0.0, range * 0.5, (double)this.m_20206_() + 0.02, range);
    }

    public abstract void handleRidingCommand(int var1);

    public boolean isStaying() {
        return this.behaviour == Behaviour.STAY;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.setBehaviour(behaviour, false);
    }

    private void setBehaviour(Behaviour behaviour, boolean load) {
        this.f_19804_.m_135381_(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.f_19853_.f_46443_) {
            this.updateAI(false, load);
        }
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean doStartRide(ServerPlayer player) {
        if (this.rideable()) {
            player.m_20329_((Entity)this);
            return true;
        }
        player.m_6352_((Component)new TranslatableComponent("runecraftory.monster.interact.ride.no"), Util.f_137441_);
        return false;
    }

    protected float tamingMultiplier(ItemStack stack) {
        boolean flag = stack.m_204117_(this.tamingItem());
        return flag ? 2.0f : 1.0f;
    }

    protected void tameEntity(Player owner) {
        if (!this.m_6084_()) {
            return;
        }
        this.m_21446_(this.m_142538_(), -1);
        this.setOwner(owner);
        this.f_21344_.m_26573_();
        this.m_6710_(null);
        this.f_19853_.m_7605_((Entity)this, (byte)10);
        this.updater.setLastUpdateDay(WorldUtils.day(this.f_19853_));
        if (Platform.INSTANCE.getPlayerData(owner).map(d -> d.party.isPartyFull()).orElse(true).booleanValue()) {
            this.setBehaviour(Behaviour.WANDER);
        } else {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        this.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), this.m_142469_().m_82400_(32.0), e -> {
            if (e == this) return false;
            if (!(e instanceof OwnableEntity)) return false;
            OwnableEntity ownable = (OwnableEntity)e;
            if (!this.m_142504_().equals(ownable.m_142504_())) return false;
            if (e.m_5448_() != this) return false;
            return true;
        }).forEach(e -> {
            e.m_6710_(null);
            if (e.m_142581_() == this) {
                e.m_6703_(null);
            }
        });
        this.m_6703_(null);
        if (owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            Platform.INSTANCE.getPlayerData((Player)serverPlayer).ifPresent(data -> {
                data.entityStatsTracker.tameEntity(this);
                ModCriteria.TAME_MONSTER_TRIGGER.trigger(serverPlayer, this, data.entityStatsTracker);
                LevelCalc.levelSkill(serverPlayer, data, EnumSkills.TAMING, 10.0f);
            });
            QuestHandler.getData(serverPlayer).trigger(TamingTracker.KEY, this);
        }
        if (this.m_20194_() != null) {
            this.assignBarn();
        }
    }

    private boolean findNearestBarn(boolean load) {
        if (load) {
            return this.assignBarn();
        }
        BarnData nearest = WorldHandler.get(this.m_20194_()).findNearestFittingBarn(this, 5);
        if (nearest != null) {
            if (this.assignedBarn != null && this.assignedBarn != nearest) {
                this.assignedBarn.removeMonster(this);
            }
            this.assignedBarn = nearest;
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return this.assignBarn();
    }

    private boolean assignBarn() {
        if (!this.m_6084_()) {
            return false;
        }
        if (this.assignedBarn == null || this.assignedBarn.isInvalidFor(this)) {
            this.assignedBarn = WorldHandler.get(this.m_20194_()).findFittingBarn(this);
        }
        if (this.assignedBarn != null) {
            this.assignedBarn.addMonster(this, this.getProp().size);
            return true;
        }
        return false;
    }

    public BarnData getAssignedBarn() {
        this.assignBarn();
        return this.assignedBarn;
    }

    protected void untameEntity() {
        this.f_19853_.m_142425_(EntityTypeTest.m_156916_(Mob.class), this.m_142469_().m_82400_(32.0), e -> e != this && e.m_5448_() == this).forEach(e -> {
            e.m_6710_(null);
            if (e.m_142581_() == this) {
                e.m_6703_(null);
            }
        });
        if (this.m_20194_() != null && this.m_142504_() != null) {
            WorldHandler.get(this.m_20194_()).removeMonsterFromPlayer(this.m_142504_(), this);
            if (this.getOwner() != null) {
                Platform.INSTANCE.getPlayerData(this.getOwner()).ifPresent(d -> d.party.removePartyMember((Entity)this));
            } else {
                WorldHandler.get(this.m_20194_()).toRemovePartyMember((LivingEntity)this);
            }
            this.assignedBarn = null;
        }
        this.setOwner(null);
        this.m_6703_(null);
        if (this.playDeath()) {
            this.m_5634_(this.m_21233_());
        }
        this.setBehaviour(Behaviour.WANDER);
        this.updateAI(true, false);
        this.m_6710_(null);
        this.m_21573_().m_26573_();
    }

    public BlockPos getSeedInventory() {
        if (this.seedInventory != null && !this.m_21444_(this.seedInventory)) {
            return null;
        }
        return this.seedInventory;
    }

    public BlockPos getCropInventory() {
        if (this.cropInventory != null && !this.m_21444_(this.cropInventory)) {
            return null;
        }
        return this.cropInventory;
    }

    public void setSeedInventory(BlockPos seedInventory) {
        this.seedInventory = seedInventory;
    }

    public void setCropInventory(BlockPos cropInventory) {
        this.cropInventory = cropInventory;
    }

    protected void m_20348_(Entity passenger) {
        this.m_21573_().m_26573_();
        this.m_20256_(Vec3.f_82478_);
        this.m_21567_(0.0f);
        this.m_21564_(0.0f);
        this.m_21570_(0.0f);
        this.m_6710_(null);
        super.m_20348_(passenger);
    }

    protected void m_20351_(Entity passenger) {
        if (passenger == this.getOwner()) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        super.m_20351_(passenger);
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public boolean m_6146_() {
        return this.m_6040_();
    }

    public boolean adjustRotFromRider(LivingEntity rider) {
        return true;
    }

    public abstract void playInteractionAnimation();

    @Override
    public boolean canBeAttackedBy(LivingEntity entity) {
        if (entity instanceof Mob) {
            Mob m = (Mob)entity;
            if (entity.m_6095_().m_204039_(RunecraftoryTags.TAMED_MONSTER_IGNORE) && this.m_5448_() != m && m.m_142581_() != this) {
                return !this.isTamed();
            }
        }
        return true;
    }

    public void m_141960_(EntityInLevelCallback levelCallback) {
        super.m_141960_(WorldUtils.wrappedCallbackFor(this, this::getOwner, levelCallback));
    }

    @Override
    public Predicate<LivingEntity> validTargetPredicate() {
        return this.hitPred;
    }

    public boolean allowAnimation(String prev, @Nullable AnimatedAction other) {
        return true;
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        data.runIf(SyncableDatas.TARGET_POS, pos -> {
            this.targetPosition = pos;
        });
    }

    private void handleTestingTick() {
        if (!TESTING) {
            return;
        }
        AnimatedAction anim = null;
        if (anim != null && !this.getAnimationHandler().isCurrent(new AnimatedAction[]{anim})) {
            this.getAnimationHandler().setAnimation(anim);
        }
    }

    public static enum Behaviour {
        WANDER("runecraftory.monster.interact.wander", false),
        WANDER_HOME("runecraftory.monster.interact.home", false),
        FOLLOW("runecraftory.monster.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.monster.interact.follow.distance", true),
        STAY("runecraftory.monster.interact.stay", true),
        FARM("runecraftory.monster.interact.farm", false);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }

    public static enum MoveType {
        NONE,
        WALK,
        RUN,
        SNEAK;

    }

    public record CombatRecord(ServerPlayer player, DamageSource lastSource, float totalDamage) {
    }
}

