/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.spells.TeleportSpell;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IOverlayEntityRender;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class BossMonster
extends BaseMonster
implements IOverlayEntityRender {
    protected static final List<Supplier<Attribute>> STAT_INCREASE = List.of(() -> Attributes.f_22281_, ModAttributes.DEFENCE, ModAttributes.MAGIC, ModAttributes.MAGIC_DEFENCE);
    protected static final UUID STAT_INCREASE_ID = UUID.fromString("fc5aaf23-4e83-4f7d-a4f0-675350d6e5e7");
    private static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(BossMonster.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final RunecraftoryBossbar bossInfo = this.createBossBar();
    private int combatTick;
    private int noPlayerRegenTick;
    private int fullHealDelay;
    private ResourceKey<Level> restrictDimension;

    public BossMonster(EntityType<? extends BossMonster> type, Level level) {
        super(type, level);
    }

    public static <T extends BaseMonster> ImmutableMap<String, BiConsumer<AnimatedAction, T>> createAnimationHandler(Consumer<ImmutableMap.Builder<AnimatedAction, BiConsumer<AnimatedAction, T>>> cons) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        cons.accept(builder);
        return (ImmutableMap)builder.build().entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((AnimatedAction)e.getKey()).getID(), Map.Entry::getValue));
    }

    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.PROGRESS);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENRAGED, (Object)false);
    }

    public void m_6075_() {
        super.m_6075_();
        if (!this.f_19853_.f_46443_) {
            if (!this.isTamed() && this.m_6084_()) {
                this.updatePlayers();
                this.updateBossBar();
                if (this.m_5448_() == null && this.bossInfo.m_8324_().isEmpty()) {
                    if (++this.combatTick > 400 && ++this.noPlayerRegenTick > 40) {
                        this.m_5634_(this.m_21233_() * 0.1f);
                        if (this.m_21223_() >= this.m_21233_()) {
                            this.fullyHeal();
                        }
                        this.noPlayerRegenTick = 0;
                    }
                    if (this.combatTick > 600 && this.m_21536_() && !this.m_21533_() && this.restrictDimension != null) {
                        BlockPos restrict = this.m_21534_();
                        if (this.f_19853_.m_46472_().equals(this.restrictDimension)) {
                            TeleportSpell.safeTeleportTo((Entity)this, restrict.m_123341_(), restrict.m_123342_(), restrict.m_123343_());
                        } else {
                            ServerLevel serverLevel = this.m_20194_().m_129880_(this.restrictDimension);
                            if (serverLevel != null) {
                                TeleportSpell.changeDimension((Entity)this, serverLevel, restrict.m_123341_(), restrict.m_123342_(), restrict.m_123343_());
                            }
                        }
                    }
                } else {
                    this.combatTick = 0;
                    this.noPlayerRegenTick = 0;
                }
            }
            if (--this.fullHealDelay == 1) {
                this.fullyHeal();
            }
        }
    }

    public void m_21446_(@Nullable BlockPos pos, int distance) {
        super.m_21446_(pos, distance);
        this.restrictDimension = this.f_19853_.m_46472_();
    }

    public void m_147271_() {
        super.m_147271_();
        this.restrictDimension = null;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Enraged", this.isEnraged());
        compound.m_128405_("FullHealDelay", this.fullHealDelay);
        if (this.restrictDimension != null) {
            compound.m_128359_("RestrictDim", this.restrictDimension.m_135782_().toString());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setEnraged(compound.m_128471_("Enraged"), true);
        this.fullHealDelay = compound.m_128451_("FullHealDelay");
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        if (compound.m_128441_("RestrictDim")) {
            this.restrictDimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("RestrictDim")));
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    @Override
    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public void setOwner(Player player) {
        super.setOwner(player);
        if (player != null) {
            this.bossInfo.m_7706_();
        }
    }

    @Override
    protected void m_6153_() {
        super.m_6153_();
        if (!this.f_19853_.f_46443_ && this.f_20919_ == 1) {
            this.updateBossBar();
        }
        if (this.f_19853_.f_46443_ && this.f_20919_ > 1) {
            if (this.f_20919_ < 40) {
                if (this.f_20919_ % 10 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                }
            } else if (this.f_20919_ < 80) {
                if (this.f_20919_ % 2 == 0) {
                    this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 2.0f), this.m_20186_() + this.f_19796_.nextDouble() * (double)(this.m_20206_() + 1.0f), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 2.0f), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                }
            } else {
                int amount = (this.f_20919_ - 80) / 10;
                for (int i = 0; i < amount; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 3.0f), this.m_20186_() + this.f_19796_.nextDouble() * (double)(this.m_20206_() + 1.0f), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)(this.m_20205_() + 3.0f), this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02, this.f_19796_.nextGaussian() * 0.02);
                }
            }
        }
    }

    @Override
    public int maxDeathTime() {
        return 200;
    }

    @Override
    protected float tamingMultiplier(ItemStack stack) {
        boolean flag = stack.m_204117_(this.tamingItem());
        return flag ? 1.0f : 0.0f;
    }

    @Override
    protected void tameEntity(Player owner) {
        super.tameEntity(owner);
        this.setEnraged(false, false);
    }

    public boolean isEnraged() {
        return this.m_6084_() && !this.isTamed() && (Boolean)this.f_19804_.m_135370_(ENRAGED) != false;
    }

    public void setEnraged(boolean flag, boolean load) {
        this.f_19804_.m_135381_(ENRAGED, (Object)flag);
        if (!load) {
            if (flag) {
                STAT_INCREASE.forEach(att -> {
                    AttributeInstance inst = this.m_21051_((Attribute)att.get());
                    if (inst.m_22111_(STAT_INCREASE_ID) == null) {
                        inst.m_22125_(new AttributeModifier(STAT_INCREASE_ID, "rf.boss_stat_increase", 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                });
            } else {
                STAT_INCREASE.forEach(att -> this.m_21051_((Attribute)att.get()).m_22120_(STAT_INCREASE_ID));
            }
        }
        if (flag && !load && this.m_6084_()) {
            this.playAngrySound();
        }
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 25 + this.m_21187_().nextInt(20) : 30 + this.m_21187_().nextInt(25)) + diffAdd;
    }

    protected void updateBossBar() {
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected void m_6475_(DamageSource damageSrc, float damageAmount) {
        super.m_6475_(damageSrc, damageAmount);
        this.combatTick = 0;
        if (!this.isTamed() && this.checkRage()) {
            this.setEnraged(true, false);
        }
    }

    @Override
    public void onDeathDamageRecord(ServerPlayer player, DamageSource source, float damage) {
        super.onDeathDamageRecord(player, source, damage);
        if (!this.isTamed() && (double)damage > (double)this.m_21233_() * 0.05 && (this.f_20897_ <= 0 || player != this.m_21232_())) {
            player.m_5993_((Entity)this, this.f_20897_, source);
        }
    }

    protected boolean checkRage() {
        return (double)(this.m_21223_() / this.m_21233_()) < 0.5 && !this.isEnraged();
    }

    protected void fullyHeal() {
        this.m_5634_(this.m_21233_());
        this.setEnraged(false, false);
    }

    private void updatePlayers() {
        HashSet<ServerPlayer> set = new HashSet<ServerPlayer>();
        for (ServerPlayer serverPlayer : this.f_19853_.m_6443_(ServerPlayer.class, this.arenaAABB(), e -> true)) {
            this.bossInfo.m_6543_(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set2 = Sets.newHashSet((Iterable)this.bossInfo.m_8324_());
        set2.removeAll(set);
        for (ServerPlayer serverPlayer : set2) {
            this.bossInfo.removePlayerFading(serverPlayer);
        }
    }

    public AABB arenaAABB() {
        if (this.m_21536_()) {
            return new AABB(this.m_21534_()).m_82400_((double)(this.m_21535_() + 1.0f));
        }
        return this.m_142469_().m_82400_(Math.max(48.0, this.m_21133_(Attributes.f_22277_) + 1.0));
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        for (ServerPlayer player : this.bossInfo.m_8324_()) {
            this.m_6452_(player);
        }
    }

    @Override
    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
        if (this.m_6084_() && !this.isTamed() && player.m_146910_() && this.bossInfo.m_8324_().isEmpty()) {
            this.fullHealDelay = 10;
        }
    }

    public int overlayU(int orig) {
        return this.isEnraged() ? (int)(Math.sin((float)this.f_19797_ / 7.0f) * 5.0 + 5.0) : orig;
    }

    public int overlayV(int orig) {
        return this.isEnraged() ? 0 : orig;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (other == null) {
            return super.allowAnimation(prev, null);
        }
        return !prev.equals(other.getID());
    }

    public void playAngrySound() {
        this.m_5496_(SoundEvents.f_12250_, 1.0f, (this.m_21187_().nextFloat() - this.m_21187_().nextFloat()) * 0.2f + 0.8f);
    }
}

