/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class ChargingMonster
extends BaseMonster {
    protected List<LivingEntity> hitEntity;
    private Vec3 chargeMotion;
    private float prevStepHeight = -1.0f;
    private final Consumer<AnimatedAction> chargingAnim = this.animatedActionConsumer();
    private boolean initAnim;

    public ChargingMonster(EntityType<? extends ChargingMonster> type, Level level) {
        super(type, level);
    }

    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            if (!this.f_19853_.f_46443_) {
                if (anim != null && this.isChargingAnim((AnimatedAction)anim)) {
                    this.prevStepHeight = this.f_19793_;
                    this.f_19793_ = Math.max(1.5f, 1.0f + this.f_19793_);
                } else if (this.prevStepHeight != -1.0f) {
                    this.f_19793_ = this.prevStepHeight;
                    this.prevStepHeight = -1.0f;
                }
                if (this.isChargingAnimation()) {
                    this.hitEntity = null;
                } else {
                    this.chargeMotion = null;
                }
            }
        };
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimatedAction)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.fixedYaw()) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (this.isChargingAnim(anim)) {
            if (this.chargeMotion == null) {
                this.setChargeMotion(this.getChargeTo(anim));
            }
            this.m_21573_().m_26573_();
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (!this.handleChargeMovement(anim)) {
                    return;
                }
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<LivingEntity>();
                }
                this.mobAttack(anim, this.m_5448_(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((LivingEntity)e);
                        this.m_7327_((Entity)e);
                    }
                });
                this.doWhileCharge();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected abstract boolean isChargingAnim(AnimatedAction var1);

    protected boolean fixedYaw() {
        return this.isChargingAnimation();
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (!this.isChargingAnim(anim)) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.m_20205_();
        double speed = Math.max(width, this.m_20184_().m_82553_() - width);
        float yRot = 0.0f;
        if (this.chargeMotion != null) {
            yRot = MathsHelper.YRotFrom(this.chargeMotion);
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82400_(0.2).m_82400_(grow).m_82363_(0.0, 0.0, speed), yRot, 0.0f, this.m_20182_());
    }

    @Override
    public boolean adjustRotFromRider(LivingEntity rider) {
        return !this.isChargingAnimation();
    }

    public void setChargeMotion(Vec3 chargeMotion) {
        this.chargeMotion = chargeMotion;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    public Vec3 getChargeMotion() {
        return this.chargeMotion;
    }

    public void m_7334_(Entity entity) {
        if (this.isChargingAnimation()) {
            return;
        }
        super.m_7334_(entity);
    }

    public boolean handleChargeMovement(AnimatedAction anim) {
        if (this.chargeMotion != null) {
            this.m_20334_(this.chargeMotion.f_82479_, this.m_20184_().f_82480_, this.chargeMotion.f_82481_);
            return true;
        }
        return false;
    }

    public void doWhileCharge() {
    }

    public double chargingSpeed() {
        return 0.4;
    }

    public Vec3 getChargeTo(AnimatedAction anim) {
        return EntityUtils.getTargetDirection((Mob)this, EntityAnchorArgument.Anchor.FEET, true).m_82490_(this.chargingSpeed());
    }

    private boolean isChargingAnimation() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isChargingAnim(anim);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, charge -> {
            this.chargeMotion = charge;
        });
    }
}

