/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityTreasureChest;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GateEntity
extends Mob
implements IBaseMob {
    private static final Map<EnumElement, ResourceLocation> LOOT_RES = new HashMap<EnumElement, ResourceLocation>();
    private static final EntityDataAccessor<String> ELEMENT_TYPE = SynchedEntityData.m_135353_(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> ELEMENT = SynchedEntityData.m_135353_(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOB_LEVEL = SynchedEntityData.m_135353_(GateEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID ATTRIBUTE_LEVEL_MOD = UUID.fromString("EC84560E-5266-4DC3-A4E1-388b97DBC0CB");
    public int rotate;
    public int clientRenderTick;
    private final List<EntityType<?>> spawnList = new ArrayList();
    private EnumElement type = EnumElement.NONE;
    private boolean initialSpawn = true;
    private final LevelExpPair expPair = new LevelExpPair();
    private boolean removeCauseEmptyList;
    private int maxNearby;
    private int spawnDelay;

    public GateEntity(EntityType<? extends GateEntity> type, Level level) {
        super(type, level);
        if (level.f_46443_) {
            this.rotate = level.f_46441_.nextInt(2) == 0 ? 1 : -1;
        }
        this.updateAttributes();
        this.m_20242_(true);
        this.maxNearby = this.m_21187_().nextInt(1 + MobConfig.maxNearby - MobConfig.minNearby) + MobConfig.minNearby;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_((Attribute)ModAttributes.DEFENCE.get()).m_22266_((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22266_((Attribute)ModAttributes.RES_WATER.get()).m_22266_((Attribute)ModAttributes.RES_EARTH.get()).m_22266_((Attribute)ModAttributes.RES_WIND.get()).m_22266_((Attribute)ModAttributes.RES_FIRE.get()).m_22266_((Attribute)ModAttributes.RES_DARK.get()).m_22266_((Attribute)ModAttributes.RES_LIGHT.get()).m_22266_((Attribute)ModAttributes.RES_LOVE.get());
    }

    public static boolean gateSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, BlockState state, Random random) {
        BlockPos blockPos = pos.m_7495_();
        return spawnType == MobSpawnType.SPAWNER || level.m_8055_(blockPos).m_60643_((BlockGetter)level, blockPos, type) || level.m_5736_() - 5 > pos.m_123342_() && state.m_60819_().m_205070_(FluidTags.f_13131_);
    }

    public static boolean canSpawnAt(EntityType<? extends GateEntity> type, ServerLevelAccessor level, MobSpawnType reason, BlockPos pos, Random random) {
        BlockState state = level.m_8055_(pos);
        return level.m_46791_() != Difficulty.PEACEFUL && DataPackHandler.INSTANCE.gateSpawnsManager().hasSpawns(level, pos, state) && level.m_6018_().m_8904_().m_27186_(PoiType.f_27347_.m_27392_(), p -> true, pos, MobConfig.bellRadius, PoiManager.Occupancy.ANY).isEmpty() && GateEntity.gateSpawnRules(type, (LevelAccessor)level, reason, pos, state, random) && level.m_45976_(GateEntity.class, new AABB(pos).m_82400_(MobConfig.minDist)).size() < MobConfig.maxGroup;
    }

    public static ResourceLocation getGateLootLocation(EnumElement element) {
        ResourceLocation def = ((EntityType)ModEntities.GATE.get()).m_20677_();
        return LOOT_RES.computeIfAbsent(element, e -> new ResourceLocation(def.m_135827_(), def.m_135815_() + "_" + e.name().toLowerCase(Locale.ROOT)));
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    @Override
    public LevelExpPair level() {
        this.expPair.setLevel((Integer)this.f_19804_.m_135370_(MOB_LEVEL), l -> 0);
        return this.expPair;
    }

    @Override
    public int friendPoints(UUID uuid) {
        return -1;
    }

    @Override
    public void setLevel(int lvl) {
        this.f_19804_.m_135381_(MOB_LEVEL, (Object)Mth.m_14045_((int)lvl, (int)1, (int)10000));
    }

    @Override
    public int baseXP() {
        return MobConfig.gateXp;
    }

    @Override
    public int baseMoney() {
        return MobConfig.gateMoney;
    }

    @Override
    public boolean applyFoodEffect(ItemStack stack) {
        return false;
    }

    @Override
    public void removeFoodEffect() {
    }

    public EnumElement getElement() {
        return this.type;
    }

    public String elementName() {
        return (String)this.f_19804_.m_135370_(ELEMENT_TYPE);
    }

    private void updateAttributes() {
        this.m_21051_(Attributes.f_22276_).m_22100_(MobConfig.gateHealth);
        this.m_21051_((Attribute)ModAttributes.DEFENCE.get()).m_22100_(MobConfig.gateDef);
        this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22100_(MobConfig.gateMDef);
        this.m_21153_(this.m_21233_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELEMENT_TYPE, (Object)"none");
        this.f_19804_.m_135372_(MOB_LEVEL, (Object)1);
        this.f_19804_.m_135372_(ELEMENT, (Object)0);
    }

    public void m_8119_() {
        if (Platform.INSTANCE.onLivingUpdate((LivingEntity)this)) {
            return;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.removeCauseEmptyList) {
                this.m_146870_();
                return;
            }
            this.m_20115_(6, this.m_142038_());
        } else {
            this.clientRenderTick += 10;
        }
        this.m_6075_();
        if (this.f_20903_ > 0) {
            double d0 = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            double d2 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            double d4 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            double d6 = Mth.m_14175_((double)(this.f_20907_ - (double)this.m_146908_()));
            this.m_146922_((float)((double)this.m_146908_() + d6 / (double)this.f_20903_));
            this.m_146926_((float)((double)this.m_146909_() + (this.f_20908_ - (double)this.m_146909_()) / (double)this.f_20903_));
            --this.f_20903_;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (!this.m_6142_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (!this.f_19853_.f_46443_ && --this.spawnDelay <= 0 && this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            int n = this.spawnDelay = MobConfig.minSpawnDelay >= MobConfig.maxSpawnDelay ? MobConfig.minSpawnDelay : this.m_21187_().nextInt(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
            if (this.spawnMobs(1)) {
                this.spawnDelay = (int)((double)this.spawnDelay * 0.4);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MobLevel", ((Integer)this.f_19804_.m_135370_(MOB_LEVEL)).intValue());
        ListTag list = new ListTag();
        this.spawnList.forEach(type -> list.add((Object)StringTag.m_129297_((String)Registry.f_122826_.m_7981_(type).toString())));
        compound.m_128365_("Spawns", (Tag)list);
        compound.m_128359_("Element", this.type.toString());
        compound.m_128379_("FirstSpawn", this.initialSpawn);
        compound.m_128405_("MaxNearby", this.maxNearby);
        compound.m_128405_("SpawnDelay", this.spawnDelay);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("MobLevel")) {
            this.f_19804_.m_135381_(MOB_LEVEL, (Object)compound.m_128451_("MobLevel"));
        }
        compound.m_128437_("Spawns", 8).forEach(nbt -> this.spawnList.add((EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(nbt.m_7916_()))));
        if (compound.m_128441_("Element")) {
            String el = compound.m_128461_("Element");
            try {
                this.type = EnumElement.valueOf(el);
                this.f_19804_.m_135381_(ELEMENT_TYPE, (Object)this.type.getTranslation());
                this.f_19804_.m_135381_(ELEMENT, (Object)this.type.ordinal());
            }
            catch (IllegalArgumentException e) {
                RuneCraftory.LOGGER.error("Unable to set element type for gate entity {}", (Object)this);
            }
        }
        this.initialSpawn = compound.m_128471_("FirstSpawn");
        this.maxNearby = compound.m_128451_("MaxNearby");
        this.spawnDelay = compound.m_128451_("SpawnDelay");
    }

    protected LootContext.Builder m_7771_(boolean attackedRecently, DamageSource src) {
        return super.m_7771_(attackedRecently, src);
    }

    protected ResourceLocation m_7582_() {
        return GateEntity.getGateLootLocation(this.getElement());
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    public Iterable<ItemStack> m_6168_() {
        return NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slotIn, ItemStack stack) {
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        Holder biome = level.m_204166_(this.m_142538_());
        this.type = this.getType(level, (Holder<Biome>)biome);
        LevelCalc.GateLevelResult gateLevel = LevelCalc.levelFromPos(level.m_6018_(), this.m_20182_());
        this.f_19804_.m_135381_(MOB_LEVEL, (Object)gateLevel.level());
        this.f_19804_.m_135381_(ELEMENT_TYPE, (Object)this.type.getTranslation());
        this.f_19804_.m_135381_(ELEMENT, (Object)this.type.ordinal());
        this.spawnList.addAll(DataPackHandler.INSTANCE.gateSpawnsManager().pickRandomMobs(level.m_6018_(), this, (Holder<Biome>)biome, this.f_19796_, this.f_19796_.nextInt(3) + 1, this.m_142538_(), gateLevel.nearby()));
        this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
        this.updateStatsToLevel();
        this.spawnMobs(Math.max(1, this.maxNearby - 2));
        this.spawnDelay = this.m_21187_().nextInt(MobConfig.minSpawnDelay, MobConfig.maxSpawnDelay);
        if (this.spawnList.isEmpty() && reason != MobSpawnType.SPAWN_EGG && reason != MobSpawnType.COMMAND) {
            this.removeCauseEmptyList = true;
        }
        return spawnData;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    private boolean spawnMobs(int count) {
        List nearby;
        ServerLevel serverLevel;
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel) || (serverLevel = (ServerLevel)level).m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (!this.spawnList.isEmpty() && (nearby = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(18.0), entity -> entity.m_6095_() == ModEntities.TREASURE_CHEST.get() || entity.m_6095_() == ModEntities.MONSTER_BOX.get() || entity.m_6095_() == ModEntities.GOBBLE_BOX.get() || this.spawnList.contains(entity.m_6095_()))).size() <= this.maxNearby) {
            for (int amount = 0; amount < count; ++amount) {
                BlockState state;
                boolean notSolid;
                Entity entity2;
                double x = this.m_20185_() + (double)this.f_19796_.nextInt(9) - 4.0;
                double y = this.m_20186_() + (double)this.f_19796_.nextInt(2) - 1.0;
                double z = this.m_20189_() + (double)this.f_19796_.nextInt(9) - 4.0;
                int levelRand = LevelCalc.randomizedLevel(this.f_19796_, (Integer)this.f_19804_.m_135370_(MOB_LEVEL));
                EntityType<?> type = this.spawnList.get(this.f_19796_.nextInt(this.spawnList.size()));
                if (this.initialSpawn) {
                    this.initialSpawn = false;
                    EntityType<?> chest = EntityUtils.trySpawnTreasureChest(this);
                    if (chest != null) {
                        type = chest;
                    }
                }
                if ((entity2 = type.m_20615_(this.f_19853_)) instanceof EntityTreasureChest) {
                    EntityTreasureChest chest = (EntityTreasureChest)entity2;
                    entity2.m_19890_(x, y, z, this.f_19853_.f_46441_.nextFloat() * 360.0f, 0.0f);
                    if (!this.f_19853_.m_45786_((Entity)chest)) continue;
                    EntityUtils.tieredTreasureChest(this, chest);
                    this.f_19853_.m_7967_(entity2);
                    continue;
                }
                if (!(entity2 instanceof Mob)) continue;
                Mob mob = (Mob)entity2;
                BlockPos pos = new BlockPos(x, y, z);
                while ((notSolid = !(state = this.f_19853_.m_8055_(pos.m_7495_())).m_60638_((BlockGetter)this.f_19853_, pos, entity2, Direction.UP) && !state.m_60819_().m_205070_(FluidTags.f_13131_)) && pos.m_203198_(x, y, z) < 16.0) {
                    pos = pos.m_7495_();
                }
                if (notSolid) continue;
                if (mob instanceof BaseMonster) {
                    ((BaseMonster)mob).setLevel(levelRand);
                }
                entity2.m_19890_(x, y, z, this.f_19853_.f_46441_.nextFloat() * 360.0f, 0.0f);
                if (!Platform.INSTANCE.canEntitySpawnSpawner(mob, (LevelAccessor)this.f_19853_, (float)entity2.m_20185_(), (float)entity2.m_20186_(), (float)entity2.m_20189_(), null, MobSpawnType.SPAWNER) || !this.f_19853_.m_45786_((Entity)mob)) continue;
                mob.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(mob.m_142538_()), MobSpawnType.SPAWNER, null, null);
                AttributeInstance follow = mob.m_21051_(Attributes.f_22277_);
                mob.m_21446_(this.m_142538_(), (int)Math.max(18.0, follow != null ? follow.m_22135_() * 0.75 : 0.0));
                this.f_19853_.m_7967_(entity2);
                mob.m_21373_();
            }
            return true;
        }
        return false;
    }

    protected float m_21161_(DamageSource damageSrc, float damageAmount) {
        float reduce = 0.0f;
        if (!damageSrc.m_19379_() && !damageSrc.m_19376_()) {
            reduce = damageSrc.m_19387_() ? (float)this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22135_() : (float)this.m_21051_((Attribute)ModAttributes.DEFENCE.get()).m_22135_();
        }
        float min = reduce > damageAmount * 2.0f ? 0.0f : 0.5f;
        return super.m_21161_(damageSrc, Math.max(min, damageAmount - reduce));
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_6153_() {
        if (this.f_20919_ == 5 && !this.f_19853_.f_46443_ && this.m_142581_() != null) {
            LevelCalc.addXP(this.m_142581_(), this.baseXP(), this.baseMoney(), this.level().getLevel());
        }
        super.m_6153_();
    }

    public void m_5634_(float healAmount) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_) {
            if (key.equals(MOB_LEVEL)) {
                this.updateStatsToLevel();
            }
            if (key.equals(ELEMENT)) {
                this.type = EnumElement.values()[(Integer)this.f_19804_.m_135370_(ELEMENT)];
            }
        }
    }

    public boolean m_5830_() {
        return false;
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof Player) {
            super.m_7334_(entity);
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean canBeCollidedWith(Entity other) {
        return other instanceof Player;
    }

    private void updateStatsToLevel() {
        this.m_21051_(Attributes.f_22276_).m_22120_(ATTRIBUTE_LEVEL_MOD);
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, "rf.levelMod", (double)(this.level().getLevel() - 1) * MobConfig.gateHealthGain, AttributeModifier.Operation.ADDITION));
        this.m_21051_((Attribute)ModAttributes.DEFENCE.get()).m_22120_(ATTRIBUTE_LEVEL_MOD);
        this.m_21051_((Attribute)ModAttributes.DEFENCE.get()).m_22125_(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, "rf.levelMod", (double)(this.level().getLevel() - 1) * MobConfig.gateDefGain, AttributeModifier.Operation.ADDITION));
        this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22120_(ATTRIBUTE_LEVEL_MOD);
        this.m_21051_((Attribute)ModAttributes.MAGIC_DEFENCE.get()).m_22125_(new AttributeModifier(ATTRIBUTE_LEVEL_MOD, "rf.levelMod", (double)(this.level().getLevel() - 1) * MobConfig.gateMDefGain, AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
    }

    private EnumElement getType(ServerLevelAccessor level, Holder<Biome> key) {
        EnumElement element = EnumElement.values()[this.m_21187_().nextInt(EnumElement.values().length)];
        if (key.m_203656_(RunecraftoryTags.IS_PLAINS) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.NONE;
        } else if (key.m_203656_(BiomeTags.f_207611_) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.WIND;
        } else if (key.m_203656_(RunecraftoryTags.IS_HOT) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.FIRE;
        } else if (key.m_203656_(BiomeTags.f_207606_) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.WIND;
        } else if (key.m_203656_(BiomeTags.f_207603_) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.WATER;
        } else if (key.m_203656_(RunecraftoryTags.IS_SANDY) && (double)this.m_21187_().nextFloat() < 0.5) {
            element = EnumElement.EARTH;
        } else if (key.m_203656_(RunecraftoryTags.IS_MAGICAL)) {
            if ((double)this.m_21187_().nextFloat() < 0.4) {
                element = EnumElement.LIGHT;
            } else if ((double)this.m_21187_().nextFloat() < 0.2) {
                element = EnumElement.LOVE;
            }
        } else if (key.m_203656_(RunecraftoryTags.IS_SPOOKY) && (double)this.m_21187_().nextFloat() < 0.4) {
            element = EnumElement.DARK;
        }
        if (key.m_203656_(RunecraftoryTags.IS_END)) {
            if ((double)this.m_21187_().nextFloat() < 0.3) {
                element = EnumElement.DARK;
            } else if ((double)this.m_21187_().nextFloat() < 0.3) {
                element = EnumElement.LIGHT;
            }
        }
        return element;
    }

    public boolean m_6459_(ServerPlayer player) {
        return !this.removeCauseEmptyList;
    }
}

