/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class LeapingMonster
extends BaseMonster {
    protected List<LivingEntity> hitEntity;
    private final Consumer<AnimatedAction> chargingAnim = this.animatedActionConsumer();
    private Vec3 leapingDir;
    private boolean initAnim;

    public LeapingMonster(EntityType<? extends LeapingMonster> type, Level level) {
        super(type, level);
    }

    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            if (this.isLeapingAnimation()) {
                this.hitEntity = null;
            } else {
                this.leapingDir = null;
            }
        };
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.initAnim) {
            this.getAnimationHandler().withChangeListener(anim -> {
                this.chargingAnim.accept((AnimatedAction)anim);
                return false;
            });
            this.initAnim = true;
        }
    }

    @Override
    protected Vec3 directionToLookAt() {
        if (this.getAnimationHandler().hasAnimation() && this.isLeapingAnim(this.getAnimationHandler().getAnimation())) {
            if (this.m_20184_().m_82556_() > 0.01) {
                return this.m_20184_();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (this.isLeapingAnim(anim)) {
            this.m_21573_().m_26573_();
            if (anim.isAt("attack_start")) {
                Vec3 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.m_5448_()));
                this.m_20334_(vec32.f_82479_, this.leapHeightMotion(), vec32.f_82481_);
                this.leapingDir = this.m_20184_();
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList<LivingEntity>();
                }
                this.mobAttack(anim, this.m_5448_(), e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((LivingEntity)e);
                        this.m_7327_((Entity)e);
                    }
                });
            }
        } else {
            super.handleAttack(anim);
        }
    }

    protected abstract boolean isLeapingAnim(AnimatedAction var1);

    public Vec3 getLeapVec(@Nullable Vec3 target) {
        if (target != null) {
            return new Vec3(target.f_82479_ - this.m_20185_(), 0.0, target.f_82481_ - this.m_20189_()).m_82541_();
        }
        return this.m_20154_();
    }

    public double leapHeightMotion() {
        return 0.1f;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, Vec3 target, double grow) {
        if (!this.isLeapingAnim(anim)) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double width = this.m_20205_();
        double speed = Math.max(width, this.m_20184_().m_82553_() - width);
        float yRot = 0.0f;
        if (this.leapingDir != null) {
            yRot = MathsHelper.YRotFrom(this.leapingDir);
        }
        return new OrientedBoundingBox(OrientedBoundingBox.originAABB((Entity)this).m_82400_(0.2).m_82400_(grow).m_82363_(0.0, 0.0, speed), yRot, 0.0f, this.m_20182_());
    }

    @Override
    public boolean adjustRotFromRider(LivingEntity rider) {
        return !this.isLeapingAnimation();
    }

    public void m_7334_(Entity entity) {
        if (this.isLeapingAnimation()) {
            return;
        }
        super.m_7334_(entity);
    }

    private boolean isLeapingAnimation() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && this.isLeapingAnim(anim);
    }
}

