/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities;

import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MultiPartEntity
extends Entity
implements OwnableEntity {
    private static final EntityDataAccessor<Optional<UUID>> PARENT_UUID = SynchedEntityData.m_135353_(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Float> SIZE_X = SynchedEntityData.m_135353_(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SIZE_Y = SynchedEntityData.m_135353_(MultiPartEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private Entity parent;
    private EntityDimensions dimensions = EntityDimensions.m_20398_((float)1.0f, (float)1.0f);
    private boolean addedToLevel;
    private boolean isHead;

    public MultiPartEntity(EntityType<MultiPartEntity> multipartType, Level level) {
        super(multipartType, level);
    }

    public MultiPartEntity(Entity parent, float width, float height) {
        super((EntityType)ModEntities.MULTIPART.get(), parent.f_19853_);
        this.setSize(width, height);
        this.setParent(parent);
    }

    public void setParent(Entity parent) {
        this.f_19804_.m_135381_(PARENT_UUID, Optional.of(parent.m_142081_()));
        this.parent = parent;
    }

    public MultiPartEntity setHeadPart() {
        this.isHead = true;
        return this;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(PARENT_UUID, Optional.empty());
        this.f_19804_.m_135372_(SIZE_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SIZE_Y, (Object)Float.valueOf(0.0f));
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.dimensions;
    }

    public Component m_7755_() {
        return this.parent.m_7755_();
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        if (!(this.f_19853_.f_46443_ || this.m_142480_() != null && this.m_142480_().m_6084_())) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        super.m_8119_();
    }

    public void m_6075_() {
        super.m_6075_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return this.m_142480_() != null && this.m_142480_().m_6469_(source, amount);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.m_142480_() != null ? this.m_142480_().m_6096_(player, hand) : InteractionResult.PASS;
    }

    public boolean m_7337_(Entity entity) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        if (this.m_142480_() != null && this.m_142480_().m_6673_(source)) {
            return true;
        }
        return source == DamageSource.f_19315_ || source == DamageSource.f_19312_ || !this.isHead && source == DamageSource.f_19310_ || super.m_6673_(source);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (SIZE_Y.equals(key)) {
            this.setSize(((Float)this.f_19804_.m_135370_(SIZE_X)).floatValue(), ((Float)this.f_19804_.m_135370_(SIZE_Y)).floatValue());
        }
    }

    public MultiPartEntity setSizeX(float x) {
        this.setSize(x, this.dimensions.f_20378_);
        return this;
    }

    public MultiPartEntity setSizeY(float y) {
        this.setSize(this.dimensions.f_20377_, y);
        return this;
    }

    public MultiPartEntity setSize(float x, float y) {
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(SIZE_X, (Object)Float.valueOf(x));
            this.f_19804_.m_135381_(SIZE_Y, (Object)Float.valueOf(y));
        }
        this.dimensions = EntityDimensions.m_20398_((float)x, (float)y);
        this.m_6210_();
        return this;
    }

    public boolean m_6087_() {
        return this.m_142480_() != null;
    }

    public void m_141960_(EntityInLevelCallback entityInLevelCallback) {
        super.m_141960_(entityInLevelCallback);
        this.addedToLevel = true;
    }

    public boolean isAddedToLevel() {
        return this.addedToLevel;
    }

    public boolean m_20068_() {
        return true;
    }

    public void updatePositionTo(double x, double y, double z, boolean simple) {
        if (this.m_142480_() != null && !this.isAddedToLevel()) {
            this.m_6034_(x, y, z);
            this.f_19853_.m_7967_((Entity)this);
        }
        Vec3 old = this.m_20182_();
        this.m_146867_();
        if (simple) {
            this.m_6034_(x, y, z);
        } else {
            this.m_6853_(true);
            double vy = y - old.f_82480_;
            if (vy >= 0.0 && vy < 1.5) {
                vy = vy <= 1.0 ? -0.08 : 0.0;
            }
            this.m_6478_(MoverType.SELF, new Vec3(x - old.f_82479_, vy, z - old.f_82481_));
        }
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).orElse(null);
    }

    @Nullable
    public Entity m_142480_() {
        if (this.parent != null && this.parent.m_6084_()) {
            return this.parent;
        }
        ((Optional)this.f_19804_.m_135370_(PARENT_UUID)).ifPresent(uuid -> {
            this.parent = EntityUtil.findFromUUID(Entity.class, (Level)this.f_19853_, (UUID)uuid);
        });
        return this.parent;
    }
}

