/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai;

import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public abstract class FollowEntityGoal<T extends Mob>
extends Goal {
    public static final double TP_DISTANCE_SQRT = 225.0;
    protected final T mob;
    private final double speedModifier;
    protected float stopDistance;
    protected float startDistance;
    protected final float ignoreTargetDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;
    protected double tpDistanceSqrt = 225.0;

    public FollowEntityGoal(T mob, double speed, float startDist, float stopDist, float ignoreTargetDist) {
        this.mob = mob;
        this.speedModifier = speed;
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.ignoreTargetDist = ignoreTargetDist;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public abstract LivingEntity getEntityToFollow();

    public abstract boolean canFollow();

    public boolean m_8036_() {
        LivingEntity livingEntity = this.getEntityToFollow();
        if (livingEntity == null) {
            return false;
        }
        if (livingEntity.m_5833_()) {
            return false;
        }
        if (!this.canFollow()) {
            return false;
        }
        if (this.mob.m_5448_() != null) {
            if (this.mob.m_20280_((Entity)livingEntity) < (double)(this.ignoreTargetDist * this.ignoreTargetDist)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }
        if (this.mob.m_20280_((Entity)livingEntity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        if (this.mob.m_21573_().m_26571_()) {
            return false;
        }
        if (!this.canFollow()) {
            return false;
        }
        return !(this.mob.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.owner = null;
        this.mob.m_21573_().m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.mob.m_8132_());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.m_183277_(10);
        if (this.mob.m_21523_() || this.mob.m_20159_()) {
            return;
        }
        if (this.mob.m_20280_((Entity)this.owner) < this.tpDistanceSqrt || !this.teleportToOwner()) {
            this.moveToFollower(this.owner, this.speedModifier);
        }
    }

    protected void moveToFollower(LivingEntity follower, double speed) {
        this.mob.m_21573_().m_5624_((Entity)follower, speed);
    }

    private boolean teleportToOwner() {
        BlockPos blockPos = this.owner.m_142538_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 2);
            int l = this.randomIntInclusive(-3, 3);
            if (!this.maybeTeleportTo(blockPos.m_123341_() + j, blockPos.m_123342_() + k, blockPos.m_123343_() + l)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 2.0 && Math.abs((double)z - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!TeleportUtils.validTeleportPlace(this.mob, new BlockPos(x, y, z), this::canTeleportOn)) {
            return false;
        }
        this.mob.m_7678_((double)x + 0.5, (double)y, (double)z + 0.5, this.mob.m_146908_(), this.mob.m_146909_());
        this.mob.m_21573_().m_26573_();
        return true;
    }

    protected abstract boolean canTeleportOn(BlockState var1);

    private int randomIntInclusive(int min, int max) {
        return this.mob.m_21187_().nextInt(max - min + 1) + min;
    }
}

