/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.FollowEntityGoal;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FollowOwnerGoalMonster
extends FollowEntityGoal<BaseMonster> {
    private final float originStartDistance;
    private final float originStopDistance;

    public FollowOwnerGoalMonster(BaseMonster mob, double speed, float startDist, float stopDist, float ignoreTargetDist) {
        super(mob, speed, startDist, stopDist, ignoreTargetDist);
        this.originStartDistance = startDist;
        this.originStopDistance = stopDist;
    }

    @Override
    public LivingEntity getEntityToFollow() {
        if (((BaseMonster)this.mob).behaviourState() == BaseMonster.Behaviour.FOLLOW_DISTANCE) {
            this.startDistance = this.originStartDistance + 6.0f;
            this.stopDistance = this.originStopDistance + 3.0f;
            this.tpDistanceSqrt = 450.0;
        } else {
            this.startDistance = this.originStartDistance;
            this.stopDistance = this.originStopDistance;
            this.tpDistanceSqrt = 225.0;
        }
        return ((BaseMonster)this.mob).getOwner();
    }

    @Override
    public boolean canFollow() {
        return ((BaseMonster)this.mob).behaviourState().following;
    }

    @Override
    protected boolean canTeleportOn(BlockState state) {
        return ((BaseMonster)this.mob).isFlyingEntity() || !(state.m_60734_() instanceof LeavesBlock);
    }
}

