/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai;

import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.utils.BlockPlaceCtxHelper;
import io.github.flemmli97.runecraftory.common.utils.CropUtils;
import io.github.flemmli97.runecraftory.common.world.farming.FarmlandHandler;
import io.github.flemmli97.runecraftory.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class TendCropsGoal
extends Goal {
    private static final Predicate<ItemStack> SEED_ITEM = s -> !s.m_41619_() && s.m_41720_() instanceof BlockItem && (s.m_204117_(RunecraftoryTags.SEEDS) || s.m_41720_() == Items.f_42620_ || s.m_41720_() == Items.f_42619_);
    private final List<BlockPos> toTend = new ArrayList<BlockPos>();
    private BlockPos selected;
    protected final BaseMonster entity;
    private int checkCooldown;
    private int cooldown;
    private boolean canPlant;

    public TendCropsGoal(BaseMonster entity) {
        this.entity = entity;
    }

    public boolean m_8036_() {
        if (TendCropsGoal.cantTendToCropsAnymore(this.entity) || !this.entity.m_21536_() || --this.checkCooldown > 0) {
            return false;
        }
        this.toTend.clear();
        this.canPlant = this.entity.getSeedInventory() != null && Platform.INSTANCE.matchingInventory(this.entity.f_19853_.m_7702_(this.entity.getSeedInventory()), SEED_ITEM);
        BlockPos center = this.entity.m_21534_();
        BlockPos.MutableBlockPos mutable = this.entity.m_21534_().m_122032_();
        int radius = MobConfig.farmRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    mutable.m_122178_(center.m_123341_() + x, center.m_123342_() + y, center.m_123343_() + z);
                    if (!this.validPos((BlockPos)mutable, this.entity.f_19853_)) continue;
                    this.toTend.add(new BlockPos((Vec3i)mutable));
                }
            }
        }
        if (this.toTend.isEmpty()) {
            this.checkCooldown = 40;
            return false;
        }
        this.selected = this.toTend.remove(this.entity.m_21187_().nextInt(this.toTend.size()));
        return true;
    }

    private boolean validPos(BlockPos pos, Level level) {
        CropBlock crop;
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
            return true;
        }
        BlockState state2 = level.m_8055_(pos.m_7495_());
        if (state2.m_204336_(RunecraftoryTags.FARMLAND) && (Integer)state2.m_61143_((Property)FarmBlock.f_53243_) < 7) {
            return true;
        }
        if (state2.m_60734_() instanceof FarmBlock) {
            if (state.m_204336_(RunecraftoryTags.MONSTER_CLEARABLE)) {
                return true;
            }
            if (this.canPlant) {
                return state.m_60795_();
            }
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.toTend.isEmpty();
    }

    public void m_8041_() {
        super.m_8041_();
        this.toTend.clear();
        this.selected = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (TendCropsGoal.cantTendToCropsAnymore(this.entity)) {
            this.toTend.clear();
            return;
        }
        if (--this.cooldown > 0) {
            return;
        }
        if (this.selected == null) {
            if (this.toTend.isEmpty()) {
                return;
            }
            this.selected = this.toTend.remove(this.entity.m_21187_().nextInt(this.toTend.size()));
            boolean bl = this.canPlant = this.entity.getSeedInventory() != null && Platform.INSTANCE.matchingInventory(this.entity.f_19853_.m_7702_(this.entity.getSeedInventory()), SEED_ITEM);
            if (!this.validPos(this.selected, this.entity.f_19853_)) {
                this.selected = null;
                this.cooldown = 10;
                return;
            }
        }
        if (!this.selected.m_203195_((Position)this.entity.m_20182_(), Math.max(1.1, (double)this.entity.m_20205_() * 1.9))) {
            Vec3 to = Vec3.m_82512_((Vec3i)this.selected);
            Path path = this.entity.m_21573_().m_26524_(to.m_7096_(), to.m_7098_(), to.m_7094_(), 0);
            this.entity.m_21573_().m_26536_(path, 1.0);
            this.cooldown = this.entity.m_21187_().nextInt(5) + 5;
        } else {
            CropBlock crop;
            BlockState state = this.entity.f_19853_.m_8055_(this.selected);
            Block block = state.m_60734_();
            boolean success = false;
            if (state.m_204336_(RunecraftoryTags.MONSTER_CLEARABLE)) {
                this.breakBlock((ServerLevel)this.entity.f_19853_, this.selected, this.entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(this.entity.f_19853_.m_7702_(this.entity.getCropInventory()), (ItemStack)s) : null);
            } else if (block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state)) {
                CropUtils.harvestCropRightClick(state, this.entity.f_19853_, this.selected, (Entity)this.entity, ItemStack.f_41583_, CropUtils.getPropertiesFor(crop), InteractionHand.MAIN_HAND, this.entity.getCropInventory() != null ? s -> Platform.INSTANCE.insertInto(this.entity.f_19853_.m_7702_(this.entity.getCropInventory()), (ItemStack)s) : null);
                this.entity.f_19853_.m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), this.entity.m_142469_().m_82400_(0.2), e -> true);
                success = true;
            } else {
                BlockPos pos = this.selected.m_7495_();
                BlockState state2 = this.entity.f_19853_.m_8055_(pos);
                if (state2.m_204336_(RunecraftoryTags.FARMLAND)) {
                    Item item;
                    ItemStack stack;
                    if ((Integer)state2.m_61143_((Property)FarmBlock.f_53243_) < 7) {
                        FarmlandHandler.waterLand((ServerLevel)this.entity.f_19853_, pos, state2);
                        success = true;
                    } else if (state.m_60795_() && this.entity.getSeedInventory() != null && !(stack = Platform.INSTANCE.findMatchingItem(this.entity.f_19853_.m_7702_(this.entity.getSeedInventory()), SEED_ITEM, 1)).m_41619_() && (item = stack.m_41720_()) instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        blockItem.m_40576_(BlockPlaceCtxHelper.entityPlaceAt(this.entity.f_19853_, stack, this.selected, Direction.UP));
                        success = true;
                    }
                }
            }
            if (success) {
                this.entity.m_21153_(this.entity.m_21223_() - 1.0f);
                this.entity.addXp(5 + this.entity.m_21187_().nextInt(5));
                this.entity.playInteractionAnimation();
            }
            this.selected = null;
            this.cooldown = this.entity.m_21187_().nextInt(15) + 20;
        }
    }

    private void breakBlock(ServerLevel level, BlockPos pos, Function<ItemStack, ItemStack> stackConsumer) {
        BlockEntity blockEntity;
        BlockState state = level.m_8055_(pos);
        level.m_46796_(2001, pos, Block.m_49956_((BlockState)state));
        BlockEntity blockEntity2 = blockEntity = state.m_155947_() ? level.m_7702_(pos) : null;
        if (stackConsumer != null) {
            Block.m_49874_((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)this.entity, (ItemStack)ItemStack.f_41583_).forEach(s -> {
                ItemStack rest = (ItemStack)stackConsumer.apply((ItemStack)s);
                if (!rest.m_41619_()) {
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)rest);
                }
            });
            state.m_60612_(level, pos, ItemStack.f_41583_);
        } else {
            Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)this.entity, (ItemStack)ItemStack.f_41583_);
        }
        level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static boolean cantTendToCropsAnymore(BaseMonster monster) {
        return (double)Mth.m_14143_((float)monster.m_21223_()) <= Math.max(1.0, (double)monster.m_21233_() * 0.05);
    }
}

