/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.animated;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;

public class MonsterActionUtils {
    public static <T extends ChargingMonster> GoalAttackAction.Condition<T> chargeCondition() {
        return (goal, target, previousAnim) -> {
            double heightDiff = target.m_20186_() - ((ChargingMonster)goal.attacker).m_20186_();
            return goal.distanceToTargetSq >= 9.0 && heightDiff <= 1.0 && heightDiff >= (double)(-((ChargingMonster)goal.attacker).m_6056_()) || (double)((ChargingMonster)goal.attacker).m_21187_().nextFloat() < 0.5;
        };
    }

    public static <T extends BaseMonster> GoalAttackAction<T> nonRepeatableAttack(AnimatedAction anim) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition((goal, target, previous) -> ((BaseMonster)goal.attacker).allowAnimation(previous, anim));
    }

    public static <T extends BossMonster> GoalAttackAction<T> enragedBossAttack(AnimatedAction anim) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition((goal, target, previous) -> ((BossMonster)goal.attacker).isEnraged() && ((BossMonster)goal.attacker).allowAnimation(previous, anim));
    }

    public static <T extends BaseMonster> GoalAttackAction.Condition<T> inAABBRange(AnimatedAction anim) {
        return (goal, target, previousAnim) -> {
            OrientedBoundingBox obb = ((BaseMonster)goal.attacker).prepareAttackBox(anim, target, -0.3, false);
            return obb.intersects(target.m_142469_());
        };
    }

    public static <T extends BaseMonster> GoalAttackAction<T> simpleMeleeAction(AnimatedAction anim, ActionUtils.FloatGetter<T> chance) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition(ActionUtils.chanced(chance)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0)));
    }

    public static <T extends BaseMonster> GoalAttackAction<T> simpleMeleeActionInRange(AnimatedAction anim, ActionUtils.FloatGetter<T> chance) {
        return MonsterActionUtils.simpleMeleeActionCondition(anim, chance, MonsterActionUtils.inAABBRange(anim));
    }

    public static <T extends BaseMonster> GoalAttackAction<T> simpleMeleeActionCondition(AnimatedAction anim, ActionUtils.FloatGetter<T> chance, GoalAttackAction.Condition<T> condition) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition(ActionUtils.chanced(chance, condition)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0)));
    }

    public static <T extends BaseMonster> GoalAttackAction<T> simpleRangedStrafingAction(AnimatedAction anim, float radius, float speed, ActionUtils.FloatGetter<T> chance) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition(ActionUtils.chanced(chance)).prepare(() -> new TimedWrappedRunner((ActionRun)new StrafingRunner(radius, speed), e -> e.m_21187_().nextInt(20) + 30));
    }

    public static <T extends BaseMonster> GoalAttackAction<T> simpleRangedEvadingAction(AnimatedAction anim, double max, double min, double speed, ActionUtils.FloatGetter<T> chance) {
        return new GoalAttackAction(anim).cooldown(e -> e.animationCooldown(anim)).withCondition(ActionUtils.chanced(chance)).prepare(() -> new WrappedRunner((ActionRun)new KeepDistanceRunner(min, max, speed)));
    }
}

