/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.control;

import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import java.util.function.BooleanSupplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class FreeMoveControl
extends MoveControl {
    public static final BooleanSupplier TRUE = () -> true;
    private final BooleanSupplier flying;
    private final float maxYRot;
    private final float maxXRot;

    public FreeMoveControl(Mob mob) {
        this(mob, 90.0f, 30.0f, TRUE);
    }

    public FreeMoveControl(Mob mob, BooleanSupplier flying) {
        this(mob, 90.0f, 30.0f, flying);
    }

    public FreeMoveControl(Mob mob, float maxYRot, float maxXRot, BooleanSupplier flying) {
        super(mob);
        this.maxYRot = maxYRot;
        this.maxXRot = maxXRot;
        this.flying = flying;
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.STRAFE) {
            int z;
            int y;
            int x;
            float speed = (float)(this.f_24978_ * this.getSpeedAttribute());
            float forward = this.f_24979_;
            float right = this.f_24980_;
            float len = Mth.m_14116_((float)(forward * forward + right * right));
            if ((double)len < 1.0E-4) {
                return;
            }
            len = speed / len;
            Vec3 target = MathUtils.rotate((Vec3)new Vec3(0.0, 1.0, 0.0), (Vec3)new Vec3((double)(right *= len), 0.0, (double)(forward *= len)).m_82541_().m_82490_((double)this.f_24974_.m_20205_() + 0.3), (float)(-this.f_24974_.m_146908_() * ((float)Math.PI / 180)));
            PathNavigation pathnavigate = this.f_24974_.m_21573_();
            NodeEvaluator nodeprocessor = pathnavigate.m_26575_();
            BlockPathTypes node = nodeprocessor.m_8086_((BlockGetter)this.f_24974_.f_19853_, x = Mth.m_14107_((double)(this.f_24974_.m_20185_() + target.m_7096_())), y = Mth.m_14107_((double)this.f_24974_.m_20186_()), z = Mth.m_14107_((double)(this.f_24974_.m_20189_() + target.m_7094_())));
            if (node != BlockPathTypes.WALKABLE) {
                this.f_24979_ *= -1.0f;
                this.f_24980_ *= -1.0f;
            }
            this.f_24974_.m_7910_(speed);
            this.f_24974_.m_21564_(this.f_24979_);
            this.f_24974_.m_21570_(this.f_24980_);
            this.f_24981_ = MoveControl.Operation.WAIT;
        } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.f_24974_.m_21570_(0.0f);
            Vec3 dir = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
            if (dir.m_82556_() < 1.0E-4) {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
                return;
            }
            float[] yXRot = MathsHelper.YXRotFrom(dir);
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), yXRot[0], this.maxYRot));
            this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), yXRot[1], this.maxXRot));
            float speed = (float)(this.f_24978_ * this.getSpeedAttribute());
            dir = dir.m_82541_().m_82490_((double)speed);
            this.f_24974_.m_7910_(speed);
            this.f_24974_.m_21567_((float)dir.m_7098_());
        } else {
            this.f_24974_.m_21567_(0.0f);
            this.f_24974_.m_21564_(0.0f);
        }
    }

    protected double getSpeedAttribute() {
        if (this.flying.getAsBoolean()) {
            return this.f_24974_.m_21133_(Attributes.f_22280_);
        }
        return this.f_24974_.m_21133_(Attributes.f_22279_);
    }
}

