/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class NPCAttackGoal<T extends EntityNPCBase>
extends Goal {
    protected final T attacker;
    protected LivingEntity target;
    protected int pathFindDelay;
    protected double distanceToTargetSq;
    protected boolean canSee;
    private List<NPCAction> actions;
    private int idx;
    private int actionDuration;
    private int idleTime;
    private boolean initialSelect = true;
    private NPCAction.NPCAttackAction attackAction;
    private boolean combo;

    public NPCAttackGoal(T entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.attacker = entity;
    }

    public boolean m_8036_() {
        LivingEntity living = this.attacker.m_5448_();
        if (living == null || !living.m_6084_()) {
            return false;
        }
        if (!this.attacker.m_21444_(living.m_142538_())) {
            return false;
        }
        return !((EntityNPCBase)this.attacker).getAttackActions().isEmpty();
    }

    public boolean m_8045_() {
        return super.m_8045_() && this.actions != null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        super.m_8041_();
        LivingEntity livingEntity = this.attacker.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.attacker.m_6710_(null);
        }
        this.actions = null;
        this.idx = 0;
        this.initialSelect = true;
    }

    protected void selectActionSequence() {
        this.actions = ((EntityNPCBase)this.attacker).getAttackActions().getAction((EntityNPCBase)this.attacker);
        this.idx = 0;
        this.initialSelect = true;
    }

    public void setupValues() {
        this.target = this.attacker.m_5448_();
        this.distanceToTargetSq = this.attacker.m_20280_((Entity)this.target);
        this.canSee = this.attacker.m_21574_().m_148306_((Entity)this.target);
        if (this.initialSelect) {
            this.initialSelect = false;
            NPCAction action = this.actions.get(this.idx);
            this.attackAction = action.getAction((EntityNPCBase)this.attacker);
            this.actionDuration = Math.max(1, action.getDuration((EntityNPCBase)this.attacker));
        }
    }

    public void m_8037_() {
        --this.actionDuration;
        --this.pathFindDelay;
        if (this.attacker.m_5448_() == null) {
            return;
        }
        if (this.combo) {
            boolean bl = this.combo = ((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction() || this.tryScheduleCombo();
            if (!this.combo && !((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction()) {
                ++this.idx;
                this.initialSelect = true;
                if (this.idx >= this.actions.size()) {
                    this.selectActionSequence();
                }
            }
            return;
        }
        AnimatedAction anim = ((EntityNPCBase)this.attacker).getAnimationHandler().getAnimation();
        if (anim != null || --this.idleTime > 0) {
            return;
        }
        if (this.actions == null || this.actions.isEmpty()) {
            this.selectActionSequence();
            return;
        }
        this.setupValues();
        NPCAction npcAction = this.actions.get(this.idx);
        boolean done = npcAction.doAction((EntityNPCBase)this.attacker, this, this.attackAction);
        if (done || this.actionDuration <= 0) {
            if (done && this.attackAction != null) {
                ((EntityNPCBase)this.attacker).weaponHandler.setComboCount(0);
                ((EntityNPCBase)this.attacker).weaponHandler.doWeaponAttack(this.attackAction.action(), this.attacker.m_21205_(), npcAction.getSpell());
                this.combo = this.tryScheduleCombo();
            }
            this.idleTime = npcAction.getCooldown((EntityNPCBase)this.attacker);
            if (done) {
                this.attacker.m_21573_().m_26573_();
            }
            if (!this.combo) {
                ++this.idx;
                this.initialSelect = true;
                if (this.idx >= this.actions.size()) {
                    this.selectActionSequence();
                }
            }
        }
    }

    private boolean tryScheduleCombo() {
        if (((EntityNPCBase)this.attacker).weaponHandler.isScheduledAction()) {
            return false;
        }
        int combo = ((EntityNPCBase)this.attacker).weaponHandler.getComboCount();
        if (this.attackAction != null && combo < this.attackAction.comboCount()) {
            NPCAction npcAction = this.actions.get(this.idx);
            ((EntityNPCBase)this.attacker).weaponHandler.doWeaponAttack(this.attackAction.action(), this.attacker.m_21205_(), npcAction.getSpell());
            return true;
        }
        return false;
    }

    public LivingEntity getAttackTarget() {
        return this.target;
    }

    public double getDistSqr() {
        return this.distanceToTargetSq;
    }

    public boolean canSeeTarget() {
        return this.canSee;
    }

    public void moveToEntityNearer(LivingEntity target, float speed) {
        this.moveToEntity(target, speed, 0);
    }

    public void moveToEntity(LivingEntity target, float speed, int accuracy) {
        if (this.pathFindDelay <= 0) {
            Path path = this.attacker.m_21573_().m_6570_((Entity)target, accuracy);
            if (path == null || this.attacker.m_21573_().m_26536_(path, (double)speed)) {
                this.pathFindDelay += 15;
            }
            this.pathFindDelay += this.attacker.m_21187_().nextInt(10) + 5;
        }
    }
}

