/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;

public class NPCFindPOI
extends Goal {
    protected final EntityNPCBase npc;
    private int cooldown = 2;

    public NPCFindPOI(EntityNPCBase npc) {
        this.npc = npc;
    }

    public boolean m_8036_() {
        return --this.cooldown <= 0;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        GlobalPos pos = this.npc.getBedPos();
        ServerLevel serverLevel = (ServerLevel)this.npc.f_19853_;
        if (pos == null) {
            GlobalPos found = this.findAndTakePOI(serverLevel, PoiType.f_27346_, PoiType.f_27346_.m_27392_(), p -> this.isNearOf(serverLevel, (BlockPos)p, this.npc.getWorkPlace()));
            if (found != null) {
                this.npc.setBedPos(found);
            }
        } else {
            ServerLevel poiLevel;
            BlockPos blockPos = pos.m_122646_();
            ServerLevel serverLevel2 = poiLevel = serverLevel.m_46472_() != pos.m_122640_() ? serverLevel.m_142572_().m_129880_(pos.m_122640_()) : serverLevel;
            if (poiLevel == null || !poiLevel.m_8904_().m_27091_(blockPos, PoiType.f_27346_.m_27392_())) {
                this.npc.setBedPos(null);
            } else if (this.bedIsOccupied(poiLevel, blockPos)) {
                this.npc.setBedPos(null);
                poiLevel.m_8904_().m_27154_(blockPos);
                DebugPackets.m_133719_((ServerLevel)poiLevel, (BlockPos)blockPos);
            }
        }
        this.poiCheck(this.npc.getWorkPlace(), this.npc.getShop().poiType.get(), this.npc.getShop().predicate, serverLevel, p -> this.isNearOf(serverLevel, (BlockPos)p, this.npc.getBedPos()), this.npc::setWorkPlace);
        this.poiCheck(this.npc.getMeetingPos(), PoiType.f_27347_, PoiType.f_27347_.m_27392_(), serverLevel, p -> true, this.npc::setMeetingPos);
        this.cooldown = this.npc.getWorkPlace() != null && this.npc.getBedPos() != null ? 20 : 10;
    }

    private void poiCheck(GlobalPos pos, PoiType poiType, Predicate<PoiType> predicate, ServerLevel serverLevel, Predicate<BlockPos> pred, Consumer<GlobalPos> set) {
        if (pos == null) {
            GlobalPos found;
            if (poiType != null && (found = this.findAndTakePOI(serverLevel, poiType, predicate, pred)) != null) {
                set.accept(found);
            }
        } else {
            ServerLevel poiLevel;
            BlockPos blockPos = pos.m_122646_();
            ServerLevel serverLevel2 = poiLevel = serverLevel.m_46472_() != pos.m_122640_() ? serverLevel.m_142572_().m_129880_(pos.m_122640_()) : serverLevel;
            if (poiType == null) {
                if (poiLevel != null && poiLevel.m_8904_().m_27091_(blockPos, t -> true)) {
                    poiLevel.m_8904_().m_27154_(blockPos);
                }
                set.accept(null);
            } else if (poiLevel == null || !poiLevel.m_8904_().m_27091_(blockPos, predicate)) {
                set.accept(null);
            }
        }
    }

    private GlobalPos findAndTakePOI(ServerLevel serverLevel, PoiType poiType, Predicate<PoiType> predicate, Predicate<BlockPos> pred) {
        PoiManager poiManager = serverLevel.m_8904_();
        Set set = poiManager.m_27171_(predicate, pred, this.npc.m_142538_(), 48, PoiManager.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
        if (set.isEmpty()) {
            return null;
        }
        Path path = this.npc.m_21573_().m_26548_(set, poiType.m_27397_());
        if (path != null && path.m_77403_()) {
            BlockPos blockPos2 = path.m_77406_();
            if (this.bedIsOccupied(serverLevel, blockPos2)) {
                return null;
            }
            return poiManager.m_27177_(blockPos2).map(type -> {
                poiManager.m_27133_(predicate, arg_0 -> ((BlockPos)blockPos2).equals(arg_0), blockPos2, 1);
                DebugPackets.m_133719_((ServerLevel)serverLevel, (BlockPos)blockPos2);
                return GlobalPos.m_122643_((ResourceKey)serverLevel.m_46472_(), (BlockPos)blockPos2);
            }).orElse(null);
        }
        return null;
    }

    private boolean bedIsOccupied(ServerLevel serverLevel, BlockPos blockPos) {
        BlockState blockState = serverLevel.m_8055_(blockPos);
        return blockState.m_204336_(BlockTags.f_13038_) && (Boolean)blockState.m_61143_((Property)BedBlock.f_49441_) != false && !this.npc.m_5803_();
    }

    private boolean isNearOf(ServerLevel level, BlockPos pos, GlobalPos gPos) {
        if (gPos == null) {
            return true;
        }
        if (level.m_46472_() != gPos.m_122640_()) {
            return false;
        }
        return gPos.m_122646_().m_123314_((Vec3i)pos, 16.0);
    }
}

