/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc;

import com.google.common.base.Suppliers;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NPCWanderGoal
extends Goal {
    private static final Supplier<Set<PoiType>> SHELTER_POIS = Suppliers.memoize(() -> ModNPCJobs.allJobs().stream().map(s -> s.poiType.get()).filter(Objects::nonNull).collect(Collectors.toSet()));
    protected final EntityNPCBase npc;
    private int walkCooldown;
    private int shelterPOISearchCooldown;
    private int pathFindCooldown;
    private Activity prevActivity;

    public NPCWanderGoal(EntityNPCBase npc) {
        this.npc = npc;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.npc.getEntityToFollowUUID() == null;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Activity activity = this.npc.getActivity();
        boolean changed = this.prevActivity != activity;
        this.prevActivity = activity;
        --this.shelterPOISearchCooldown;
        --this.walkCooldown;
        --this.pathFindCooldown;
        if (changed) {
            this.npc.m_21573_().m_26573_();
            this.npc.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            this.npc.m_6274_().m_21936_(MemoryModuleType.f_26326_);
        }
        this.moveToTarget();
        if (activity == Activity.f_37982_ ? this.rest() : (activity == Activity.f_37980_ ? this.work() : activity == Activity.f_37983_ && this.goMeet())) {
            return;
        }
        this.wanderAround();
    }

    public boolean rest() {
        GlobalPos pos = this.npc.getBedPos();
        if (pos != null && this.npc.f_19853_.m_46472_() == pos.m_122640_()) {
            BlockState blockState;
            if (this.npc.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty() && !this.npc.m_5803_()) {
                float spd = this.npc.m_20070_() && this.npc.m_20275_((double)pos.m_122646_().m_123341_() + 0.5, pos.m_122646_().m_123342_(), (double)pos.m_122646_().m_123343_() + 0.5) > 25.0 ? 1.3f : 1.0f;
                this.setWalkTargetTo(pos.m_122646_(), spd, 0, () -> this.npc.setBedPos(null));
            }
            if (pos.m_122646_().m_203195_((Position)this.npc.m_20182_(), 2.0) && (blockState = this.npc.f_19853_.m_8055_(pos.m_122646_())).m_204336_(BlockTags.f_13038_) && !((Boolean)blockState.m_61143_((Property)BedBlock.f_49441_)).booleanValue()) {
                this.npc.m_5802_(pos.m_122646_());
                this.npc.m_6274_().m_21936_(MemoryModuleType.f_26370_);
            }
            return true;
        }
        return false;
    }

    public boolean work() {
        GlobalPos pos = this.npc.getWorkPlace();
        if (pos != null && this.npc.f_19853_.m_46472_() == pos.m_122640_()) {
            if (pos.m_122646_().m_203195_((Position)this.npc.m_20182_(), 2.0)) {
                return true;
            }
            if (this.npc.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty()) {
                this.setWalkTargetTo(pos.m_122646_(), 1.0f, 1, () -> this.npc.setWorkPlace(null));
            }
            return true;
        }
        return false;
    }

    public boolean goMeet() {
        if (this.seekShelter()) {
            return true;
        }
        GlobalPos pos = this.npc.getMeetingPos();
        if (pos != null && this.npc.f_19853_.m_46472_() == pos.m_122640_()) {
            if (pos.m_122646_().m_203195_((Position)this.npc.m_20182_(), 6.0) && this.walkCooldown <= 0) {
                Vec3 to = this.getRandomPosition(5);
                if (to != null) {
                    this.setWalkTarget(new BlockPos(to), 1.0f, 0);
                    this.walkCooldown = this.npc.m_21187_().nextInt(40) + 90;
                } else {
                    this.walkCooldown = this.npc.m_21187_().nextInt(20) + 30;
                }
                return true;
            }
            if (this.npc.m_6274_().m_21952_(MemoryModuleType.f_26370_).isEmpty()) {
                this.setWalkTargetTo(pos.m_122646_(), 1.0f, 1, () -> this.npc.setMeetingPos(null));
            }
            return true;
        }
        return false;
    }

    public boolean seekShelter() {
        if (this.npc.f_19853_.m_46471_()) {
            if (--this.shelterPOISearchCooldown < 0) {
                Optional hide = this.npc.m_6274_().m_21952_(MemoryModuleType.f_26324_);
                if (hide.isEmpty()) {
                    PoiManager poiManager = ((ServerLevel)this.npc.f_19853_).m_8904_();
                    Set set = poiManager.m_27171_(p -> SHELTER_POIS.get().contains(p), p -> {
                        if (this.npc.getBedPos() != null) {
                            return this.npc.m_142538_().m_123331_((Vec3i)this.npc.getBedPos().m_122646_()) > p.m_123331_((Vec3i)this.npc.m_142538_());
                        }
                        return true;
                    }, this.npc.m_142538_(), 48, PoiManager.Occupancy.ANY).limit(5L).collect(Collectors.toSet());
                    boolean found = false;
                    for (BlockPos pos : set) {
                        AABB atPos = new AABB(pos).m_82400_(10.0);
                        if (this.npc.f_19853_.m_142425_(EntityTypeTest.m_156916_(EntityNPCBase.class), atPos, e -> true).size() >= 5 || !this.isUnderRoof(pos)) continue;
                        this.npc.m_6274_().m_21879_(MemoryModuleType.f_26324_, (Object)GlobalPos.m_122643_((ResourceKey)this.npc.f_19853_.m_46472_(), (BlockPos)pos));
                        found = true;
                        break;
                    }
                    if (!found) {
                        if (this.npc.getBedPos() != null && this.npc.getBedPos().m_122640_() == this.npc.f_19853_.m_46472_() && this.isUnderRoof(this.npc.getBedPos().m_122646_())) {
                            this.npc.m_6274_().m_21879_(MemoryModuleType.f_26324_, (Object)this.npc.getBedPos());
                        } else if (this.npc.getWorkPlace() != null && this.npc.getWorkPlace().m_122640_() == this.npc.f_19853_.m_46472_() && this.isUnderRoof(this.npc.getWorkPlace().m_122646_())) {
                            this.npc.m_6274_().m_21879_(MemoryModuleType.f_26324_, (Object)this.npc.getWorkPlace());
                        }
                    }
                } else if (!this.isUnderRoof(((GlobalPos)hide.get()).m_122646_())) {
                    this.npc.m_6274_().m_21936_(MemoryModuleType.f_26324_);
                }
                this.shelterPOISearchCooldown = 60 + this.npc.m_21187_().nextInt(40);
            }
            if (--this.walkCooldown <= 0 && this.npc.m_21573_().m_26571_()) {
                this.npc.m_6274_().m_21952_(MemoryModuleType.f_26324_).ifPresent(p -> {
                    Vec3 target;
                    float spd = 1.0f;
                    int acc = 0;
                    if (this.npc.m_20275_((double)p.m_122646_().m_123341_() + 0.5, p.m_122646_().m_123342_(), (double)p.m_122646_().m_123343_() + 0.5) < 49.0) {
                        target = this.getRandomPosition(6);
                        if (target != null && this.npc.f_19853_.m_45527_(new BlockPos(target))) {
                            target = null;
                        }
                    } else {
                        target = Vec3.m_82512_((Vec3i)p.m_122646_());
                        spd = 1.3f;
                        acc = 4;
                    }
                    if (target != null) {
                        this.setWalkTargetTo(new BlockPos(target), spd, acc, () -> this.npc.m_6274_().m_21936_(MemoryModuleType.f_26324_));
                        this.walkCooldown = this.npc.m_21187_().nextInt(40) + 90;
                    } else {
                        this.walkCooldown = this.npc.m_21187_().nextInt(20) + 30;
                    }
                });
            }
            return true;
        }
        if (this.npc.m_6274_().m_21952_(MemoryModuleType.f_26324_).isPresent()) {
            this.npc.m_6274_().m_21936_(MemoryModuleType.f_26324_);
        }
        return false;
    }

    public void wanderAround() {
        if (this.seekShelter()) {
            return;
        }
        if (this.walkCooldown <= 0 && this.npc.m_21573_().m_26571_()) {
            SectionPos sectionPos;
            SectionPos sectionPos2;
            ServerLevel serverLevel = (ServerLevel)this.npc.f_19853_;
            BlockPos blockPos = this.npc.m_142538_();
            Vec3 pos = serverLevel.m_8802_(blockPos) ? this.getRandomPosition(10) : ((sectionPos2 = BehaviorUtils.m_22581_((ServerLevel)serverLevel, (SectionPos)(sectionPos = SectionPos.m_123199_((BlockPos)blockPos)), (int)2)) != sectionPos ? this.setTargetedPosTowards(sectionPos2) : this.getRandomPosition(10));
            if (pos != null) {
                this.setWalkTarget(new BlockPos(pos), 1.0f, 0);
                this.walkCooldown = this.npc.m_21187_().nextInt(40) + 90;
            } else {
                this.walkCooldown = this.npc.m_21187_().nextInt(20) + 30;
            }
        }
    }

    private void setWalkTargetTo(BlockPos pos, float speed, int accuracy, Runnable onFail) {
        if (this.tiredOfTryingToFindTarget(this.npc.f_19853_, this.npc)) {
            onFail.run();
        } else if (pos.m_123333_((Vec3i)this.npc.m_142538_()) > 100) {
            int i;
            Vec3 vec3 = null;
            int attempts = 300;
            for (i = 0; i < attempts && (vec3 == null || this.distManhattan(this.npc.m_20182_(), vec3) > 100.0); ++i) {
                vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.npc, (int)15, (int)7, (Vec3)Vec3.m_82512_((Vec3i)pos), (double)1.5707963705062866);
            }
            if (i == attempts || vec3 == null) {
                onFail.run();
                return;
            }
            this.setWalkTarget(new BlockPos(vec3), speed, accuracy);
        } else {
            this.setWalkTarget(pos, speed, accuracy);
        }
    }

    private boolean tiredOfTryingToFindTarget(Level level, EntityNPCBase npc) {
        return npc.m_6274_().m_21952_(MemoryModuleType.f_26326_).map(l -> level.m_46467_() - l > 1000L).orElse(false);
    }

    private double distManhattan(Vec3 vec3, Vec3 other) {
        double f = Math.abs(vec3.m_7096_() - other.m_7096_());
        double g = Math.abs(vec3.m_7098_() - other.m_7098_());
        double h = Math.abs(vec3.m_7094_() - other.m_7094_());
        return f + g + h;
    }

    private void setWalkTarget(BlockPos pos, float speed, int accuracy) {
        this.npc.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(pos, speed, accuracy));
    }

    private void moveToTarget() {
        if (this.pathFindCooldown <= 0 && this.npc.m_21573_().m_26571_()) {
            this.npc.m_6274_().m_21952_(MemoryModuleType.f_26370_).ifPresent(target -> {
                Path path = this.npc.m_21573_().m_7864_(target.m_26420_().m_6675_(), target.m_26422_());
                boolean canReach = true;
                if (path == null || (canReach = !path.m_77403_() && (float)this.npc.m_142538_().m_123333_((Vec3i)target.m_26420_().m_6675_()) < 85.0f)) {
                    if (!this.npc.m_6274_().m_21874_(MemoryModuleType.f_26326_)) {
                        this.npc.m_6274_().m_21879_(MemoryModuleType.f_26326_, (Object)this.npc.f_19853_.m_46467_());
                    }
                    if (path == null) {
                        this.pathFindCooldown = this.npc.m_21187_().nextInt(30) + 15;
                        return;
                    }
                }
                if (canReach) {
                    this.npc.m_6274_().m_21936_(MemoryModuleType.f_26326_);
                }
                this.npc.m_21573_().m_26536_(path, (double)target.m_26421_());
                this.pathFindCooldown = this.npc.m_21187_().nextInt(15) + 15;
            });
        }
        this.npc.m_6274_().m_21952_(MemoryModuleType.f_26370_).ifPresent(target -> {
            if (this.npc.m_142538_().m_123333_((Vec3i)target.m_26420_().m_6675_()) <= target.m_26422_()) {
                this.npc.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                this.npc.m_21573_().m_26573_();
            }
        });
    }

    private boolean isUnderRoof(BlockPos pos) {
        return BlockPos.m_121990_((BlockPos)pos.m_142082_(-2, 1, -2), (BlockPos)pos.m_142082_(2, 1, 2)).noneMatch(p -> this.npc.f_19853_.m_45527_(p) && this.npc.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING, p).m_123342_() <= p.m_123342_());
    }

    @Nullable
    protected Vec3 getRandomPosition(int radius) {
        if (this.npc.m_20072_()) {
            Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.npc, (int)15, (int)7);
            return vec3 == null ? DefaultRandomPos.m_148403_((PathfinderMob)this.npc, (int)10, (int)7) : vec3;
        }
        return DefaultRandomPos.m_148403_((PathfinderMob)this.npc, (int)radius, (int)7);
    }

    private Vec3 setTargetedPosTowards(SectionPos sectionPos) {
        return DefaultRandomPos.m_148412_((PathfinderMob)this.npc, (int)10, (int)7, (Vec3)Vec3.m_82539_((Vec3i)sectionPos.m_123250_()), (double)1.5707963705062866);
    }
}

