/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.items.IItemUsable;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class AttackMeleeAction
implements NPCAction {
    public static final Codec<AttackMeleeAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("walk_time").forGetter(d -> d.walkTime), NPCAction.optionalNumCooldown(d -> d.cooldown), (App)Codec.FLOAT.fieldOf("speed").forGetter(d -> Float.valueOf(d.speed))).apply((Applicative)instance, AttackMeleeAction::new));
    private final NumberProvider walkTime;
    private final NumberProvider cooldown;
    private final float speed;

    private AttackMeleeAction(NumberProvider walkTime, Optional<NumberProvider> cooldown, float speed) {
        this(walkTime, cooldown.orElse(NPCAction.CONST_SEC), speed);
    }

    public AttackMeleeAction(NumberProvider walkTime) {
        this(walkTime, NPCAction.CONST_SEC, 1.2f);
    }

    public AttackMeleeAction(NumberProvider walkTime, float speed) {
        this(walkTime, NPCAction.CONST_SEC, speed);
    }

    public AttackMeleeAction(NumberProvider walkTime, NumberProvider cooldown, float speed) {
        this.walkTime = walkTime;
        this.cooldown = cooldown;
        this.speed = speed;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.MELEE_ATTACK;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.walkTime.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public NPCAction.NPCAttackAction getAction(EntityNPCBase npc) {
        IItemUsable usabe;
        AttackAction action;
        ItemStack hand = npc.m_21205_();
        Item item = hand.m_41720_();
        if (item instanceof IItemUsable && (action = (usabe = (IItemUsable)item).getWeaponType().getAction()) != null) {
            int amount = npc.m_21187_().nextInt(action.combos().size()) + 1;
            return new NPCAction.NPCAttackAction(action, amount);
        }
        return null;
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        goal.moveToEntityNearer(goal.getAttackTarget(), this.speed);
        npc.m_21563_().m_24960_((Entity)goal.getAttackTarget(), 30.0f, 30.0f);
        double minDist = npc.m_142593_(goal.getAttackTarget());
        if (goal.getDistSqr() <= minDist) {
            if (action == null) {
                npc.m_6674_(InteractionHand.MAIN_HAND);
                npc.npcAttack(npc::m_7327_);
            }
            npc.weaponHandler.setComboCount(npc.m_21187_().nextInt(2));
            return true;
        }
        return false;
    }
}

