/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityThrownItem;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class FoodThrowAction
implements NPCAction {
    public static final Codec<FoodThrowAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.listOf().fieldOf("items").forGetter(d -> d.items), (App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("walk_time").forGetter(d -> d.walkTime), NPCAction.optionalNumCooldown(d -> d.cooldown)).apply((Applicative)instance, FoodThrowAction::new));
    private final List<ItemStack> items;
    private final NumberProvider walkTime;
    private final NumberProvider cooldown;

    private FoodThrowAction(List<ItemStack> items, NumberProvider walkTime, Optional<NumberProvider> cooldown) {
        this(items, walkTime, cooldown.orElse(NPCAction.CONST_ZERO));
    }

    public FoodThrowAction(List<ItemStack> items, NumberProvider walkTime) {
        this(items, walkTime, NPCAction.CONST_ZERO);
    }

    public FoodThrowAction(List<ItemStack> items, NumberProvider walkTime, NumberProvider cooldown) {
        this.items = items;
        this.walkTime = walkTime;
        this.cooldown = cooldown;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.FOOD_THROW_ACTION;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.walkTime.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        if (npc.followEntity() == null || this.items.isEmpty()) {
            return true;
        }
        goal.moveToEntity((LivingEntity)npc.followEntity(), 1.0f, 2);
        npc.m_21563_().m_24960_((Entity)npc.followEntity(), 30.0f, 30.0f);
        if (npc.m_20280_((Entity)npc.followEntity()) <= 30.0) {
            npc.m_6674_(InteractionHand.MAIN_HAND);
            ItemStack stack = this.items.get(npc.m_21187_().nextInt(this.items.size())).m_41777_();
            EntityThrownItem entity = new EntityThrownItem(npc.f_19853_, (LivingEntity)npc);
            entity.setItem(stack);
            entity.setActAsFood(true);
            entity.shootAtEntity((Entity)npc.followEntity(), 0.6f, 0.0f);
            npc.f_19853_.m_7967_((Entity)entity);
            npc.m_21573_().m_26573_();
            return true;
        }
        return false;
    }
}

