/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.Entity;

public class NPCAttackActions {
    public static final Codec<NPCAttackActions> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WeightedAction.CODEC.listOf().fieldOf("actions").forGetter(d -> d.actions)).apply((Applicative)instance, NPCAttackActions::new));
    public static final NPCAttackActions DEFAULT = new NPCAttackActions(List.of());
    private final List<WeightedAction> actions;

    public NPCAttackActions(List<WeightedAction> chainedActions) {
        this.actions = ImmutableList.copyOf(chainedActions);
    }

    public List<NPCAction> getAction(EntityNPCBase npc) {
        List<WeightedAction> list = this.actions.stream().filter(w -> w.predicate.m_36607_((ServerLevel)npc.f_19853_, npc.m_20182_(), (Entity)npc)).toList();
        if (list.isEmpty()) {
            return List.of();
        }
        return WeightedRandom.m_146317_((Random)npc.m_21187_(), list).map(w -> w.chainedActions).orElse(List.of());
    }

    public boolean isEmpty() {
        return this.actions.isEmpty();
    }

    public static class WeightedAction
    implements WeightedEntry {
        public static final Codec<WeightedAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("weight").forGetter(d -> d.weight.m_146281_()), (App)CodecHelper.ENTITY_PREDICATE_CODEC.optionalFieldOf("predicate").forGetter(d -> d.predicate == EntityPredicate.f_36550_ ? Optional.empty() : Optional.of(d.predicate)), (App)CodecUtils.registryCodec(ModNPCActions.ACTIONS_REGISTRY_KEY).dispatchStable(c -> c.codec().get(), c -> c.codec).listOf().fieldOf("concurrent_actions").forGetter(d -> d.chainedActions)).apply((Applicative)instance, (weight, pred, concurrent) -> new WeightedAction((int)weight, pred.orElse(EntityPredicate.f_36550_), (List<NPCAction>)concurrent)));
        private final Weight weight;
        private final EntityPredicate predicate;
        private final List<NPCAction> chainedActions;

        public WeightedAction(int weight, EntityPredicate predicate, List<NPCAction> chainedActions) {
            this.weight = Weight.m_146282_((int)weight);
            this.predicate = predicate;
            this.chainedActions = chainedActions;
        }

        public Weight m_142631_() {
            return this.weight;
        }
    }

    public static class ActionBuilder {
        private final int weight;
        private EntityPredicate predicate = EntityPredicate.f_36550_;
        private final List<NPCAction> chainedActions = new ArrayList<NPCAction>();

        public ActionBuilder(int weight) {
            this.weight = weight;
        }

        public ActionBuilder predicate(EntityPredicate predicate) {
            this.predicate = predicate;
            return this;
        }

        public ActionBuilder action(NPCAction action) {
            this.chainedActions.add(action);
            return this;
        }

        public WeightedAction build() {
            return new WeightedAction(this.weight, this.predicate, this.chainedActions);
        }
    }

    public static class Builder {
        private final List<WeightedAction> chainedActions = new ArrayList<WeightedAction>();

        public Builder addAction(ActionBuilder builder) {
            this.chainedActions.add(builder.build());
            return this;
        }

        public NPCAttackActions build() {
            return new NPCAttackActions(this.chainedActions);
        }
    }
}

