/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class PartyTargetAction
implements NPCAction {
    public static final Codec<PartyTargetAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).fieldOf("spell").forGetter(d -> d.spell), (App)Codec.BOOL.fieldOf("ignore_seal").forGetter(d -> d.ignoreSeal), NPCAction.optionalNumCooldown(d -> d.cooldown)).apply((Applicative)instance, PartyTargetAction::new));
    private final Spell spell;
    private final boolean ignoreSeal;
    private final NumberProvider cooldown;

    private PartyTargetAction(Spell spell, boolean ignoreSeal, Optional<NumberProvider> cooldown) {
        this(spell, ignoreSeal, cooldown.orElse(NPCAction.CONST_ZERO));
    }

    public PartyTargetAction(Spell spell, boolean ignoreSeal) {
        this(spell, ignoreSeal, NPCAction.CONST_ZERO);
    }

    public PartyTargetAction(Spell spell, boolean ignoreSeal, NumberProvider cooldown) {
        this.spell = spell;
        this.ignoreSeal = ignoreSeal;
        this.cooldown = cooldown;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.PARTY_TARGET_ACTION;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return 50;
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public NPCAction.NPCAttackAction getAction(EntityNPCBase npc) {
        return NPCAction.NPCAttackAction.of((AttackAction)((Object)ModAttackActions.STAFF_USE.get()));
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        if (npc.followEntity() == null) {
            return true;
        }
        npc.m_21563_().m_24960_((Entity)npc.followEntity(), 360.0f, 90.0f);
        return true;
    }
}

