/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.Vec3;

public class RunAwayAction
implements NPCAction {
    public static final Codec<RunAwayAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("duration").forGetter(d -> d.duration), NPCAction.optionalNumCooldown(d -> d.cooldown), (App)Codec.FLOAT.fieldOf("max_dist").forGetter(d -> Float.valueOf(d.maxDist)), (App)Codec.FLOAT.fieldOf("speed").forGetter(d -> Float.valueOf(d.speed))).apply((Applicative)instance, RunAwayAction::new));
    private final NumberProvider duration;
    private final NumberProvider cooldown;
    private final float maxDist;
    private final float speed;

    private RunAwayAction(NumberProvider duration, Optional<NumberProvider> cooldown, float maxDist, float speed) {
        this(duration, cooldown.orElse(NPCAction.CONST_ZERO), maxDist, speed);
    }

    public RunAwayAction(NumberProvider duration, float maxDist) {
        this(duration, NPCAction.CONST_ZERO, maxDist, 1.3f);
    }

    public RunAwayAction(NumberProvider duration, NumberProvider cooldown, float maxDist, float speed) {
        this.duration = duration;
        this.cooldown = cooldown;
        this.maxDist = maxDist;
        this.speed = speed;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.RUN_AWAY_ACTION;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.duration.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        if (npc.m_21573_().m_26571_()) {
            if (goal.getDistSqr() > (double)(this.maxDist * this.maxDist)) {
                return true;
            }
            Vec3 vec3 = DefaultRandomPos.m_148407_((PathfinderMob)npc, (int)16, (int)7, (Vec3)goal.getAttackTarget().m_20182_());
            if (vec3 == null) {
                return false;
            }
            npc.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, (double)this.speed);
        }
        return false;
    }
}

