/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.ai.npc.actions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.NPCAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCActions;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CodecHelper;
import io.github.flemmli97.tenshilib.common.utils.CodecUtils;
import java.util.function.Supplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class SpellAttackAction
implements NPCAction {
    public static final Codec<SpellAttackAction> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecHelper.NUMER_PROVIDER_CODEC.fieldOf("walk_time").forGetter(d -> d.walkTime), NPCAction.optionalNumCooldown(d -> d.cooldown), NPCAction.optionalNum(d -> d.combos, "combos", CONST_ONE), (App)CodecUtils.registryCodec(ModSpells.SPELL_REGISTRY_KEY).fieldOf("spell").forGetter(d -> d.spell), (App)Codec.DOUBLE.fieldOf("range").forGetter(d -> d.range), (App)Codec.BOOL.fieldOf("ignore_seal").forGetter(d -> d.ignoreSeal)).apply((Applicative)instance, (walkTime, cooldown, combos, spell, range, ignoreSeal) -> new SpellAttackAction((Spell)((Object)((Object)spell)), (double)range, (boolean)ignoreSeal, (NumberProvider)walkTime, cooldown.orElse(NPCAction.CONST_ZERO), combos.orElse(NPCAction.CONST_ONE))));
    private final Spell spell;
    private final double range;
    private final boolean ignoreSeal;
    private final NumberProvider walkTime;
    private final NumberProvider cooldown;
    private final NumberProvider combos;

    public SpellAttackAction(Spell spell, double range, boolean ignoreSeal, NumberProvider walkTime, NumberProvider cooldown) {
        this(spell, range, ignoreSeal, walkTime, cooldown, (NumberProvider)ConstantValue.m_165692_((float)1.0f));
    }

    public SpellAttackAction(Spell spell, double range, boolean ignoreSeal, NumberProvider walkTime, NumberProvider cooldown, NumberProvider combos) {
        this.spell = spell;
        this.range = range;
        this.ignoreSeal = ignoreSeal;
        this.walkTime = walkTime;
        this.cooldown = cooldown;
        this.combos = combos;
    }

    @Override
    public Supplier<NPCAction.NPCActionCodec> codec() {
        return ModNPCActions.SPELL_ATTACK;
    }

    @Override
    public int getDuration(EntityNPCBase npc) {
        return this.walkTime.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public int getCooldown(EntityNPCBase npc) {
        return this.cooldown.m_142683_(NPCAction.createLootContext(npc));
    }

    @Override
    public NPCAction.NPCAttackAction getAction(EntityNPCBase npc) {
        AttackAction act = this.spell.useAction();
        int combos = Mth.m_14045_((int)this.combos.m_142683_(NPCAction.createLootContext(npc)), (int)1, (int)act.combos().size());
        return new NPCAction.NPCAttackAction(act, combos);
    }

    @Override
    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public boolean doAction(EntityNPCBase npc, NPCAttackGoal<?> goal, NPCAction.NPCAttackAction action) {
        goal.moveToEntityNearer(goal.getAttackTarget(), 1.0f);
        npc.m_21563_().m_24960_((Entity)goal.getAttackTarget(), 60.0f, 30.0f);
        return goal.canSeeTarget() && (this.range < 0.0 || goal.getDistSqr() <= this.range * this.range);
    }
}

