/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.data;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;

public class SyncableEntityData {
    private static final Map<ResourceLocation, SyncedEntityData<?>> REGISTRY = new HashMap();

    public static synchronized <T> SyncedEntityData<T> register(ResourceLocation id, EntityDataSerializer<T> serializer) {
        return SyncableEntityData.register(new SyncedEntityData<T>(id, serializer));
    }

    public static synchronized <T> SyncedEntityData<T> register(SyncedEntityData<T> inst) {
        if (REGISTRY.putIfAbsent(inst.id, inst) != null) {
            throw new IllegalStateException("ID is already registered");
        }
        return inst;
    }

    public static synchronized <T> SyncedEntityData<T> get(ResourceLocation id) {
        return REGISTRY.get(id);
    }

    public record SyncedEntityData<T>(ResourceLocation id, EntityDataSerializer<T> serializer) {
    }

    public static class SyncedContainer<T> {
        private final SyncedEntityData<T> syncedEntityData;
        private final T value;

        public SyncedContainer(SyncedEntityData<T> syncedEntityData, T value) {
            this.syncedEntityData = syncedEntityData;
            this.value = value;
        }

        public <E> void runIf(SyncedEntityData<E> other, Consumer<E> cons) {
            if (this.syncedEntityData.equals(other)) {
                T v = this.value;
                cons.accept(v);
            }
        }

        public void write(FriendlyByteBuf buf) {
            buf.m_130085_(this.syncedEntityData.id);
            buf.writeBoolean(this.value != null);
            if (this.value != null) {
                this.syncedEntityData.serializer().m_6856_(buf, this.value);
            }
        }

        public static <T> SyncedContainer<T> from(FriendlyByteBuf buf) {
            ResourceLocation id = buf.m_130281_();
            SyncedEntityData data = SyncableEntityData.get(id);
            boolean none = buf.readBoolean();
            return new SyncedContainer<Object>(data, (none ? data.serializer().m_6709_(buf) : null));
        }
    }
}

