/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.tenshilib.common.entity.EntityBeam;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class BaseBeam
extends EntityBeam {
    private Predicate<LivingEntity> pred = e -> !e.m_142081_().equals(this.m_142504_());
    protected float damageMultiplier = 1.0f;

    public BaseBeam(EntityType<? extends BaseBeam> type, Level world) {
        super(type, world);
    }

    public BaseBeam(EntityType<? extends BaseBeam> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public BaseBeam(EntityType<? extends BaseBeam> type, Level world, LivingEntity shooter) {
        super(type, world, shooter);
        if (shooter instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)shooter;
            this.pred = targetableOpponent.validTargetPredicate();
        }
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    protected boolean check(Entity e, Predicate<AABB> intersects) {
        return (!(e instanceof LivingEntity) || this.pred == null || this.pred.test((LivingEntity)e)) && super.check(e, intersects);
    }

    public Entity m_142480_() {
        Entity owner = super.m_142480_();
        if (owner instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)owner;
            this.pred = targetableOpponent.validTargetPredicate();
        }
        return owner;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("DamageMultiplier", this.damageMultiplier);
    }
}

