/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.tenshilib.common.entity.EntityDamageCloud;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDamageCloud
extends EntityDamageCloud {
    private Predicate<LivingEntity> pred = e -> !e.m_142081_().equals(this.m_142504_());
    protected float damageMultiplier = 1.0f;

    public BaseDamageCloud(EntityType<? extends BaseDamageCloud> type, Level world) {
        super(type, world);
    }

    public BaseDamageCloud(EntityType<? extends BaseDamageCloud> type, Level world, double x, double y, double z) {
        super(type, world, x, y, z);
    }

    public BaseDamageCloud(EntityType<? extends BaseDamageCloud> type, Level world, LivingEntity shooter) {
        super(type, world, shooter);
        if (shooter instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)shooter;
            this.pred = targetableOpponent.validTargetPredicate();
        }
    }

    public void setDamageMultiplier(float damageMultiplier) {
        this.damageMultiplier = damageMultiplier;
    }

    @Nullable
    public Predicate<LivingEntity> getHitPredicate() {
        return this.pred;
    }

    protected boolean canHit(LivingEntity entity) {
        return super.canHit(entity) && (this.pred == null || this.pred.test(entity));
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("DamageMultiplier", this.damageMultiplier);
    }

    public Entity m_142480_() {
        Entity owner = super.m_142480_();
        if (owner instanceof TargetableOpponent) {
            TargetableOpponent targetableOpponent = (TargetableOpponent)owner;
            this.pred = targetableOpponent.validTargetPredicate();
        }
        return owner;
    }
}

