/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalBall;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ElementBallBarrageSummoner
extends ProjectileSummonHelperEntity {
    protected static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.m_135353_(ElementBallBarrageSummoner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EnumElement element = EnumElement.NONE;

    public ElementBallBarrageSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ElementBallBarrageSummoner(Level level, LivingEntity caster, EnumElement element) {
        super((EntityType)ModEntities.ELEMENTAL_BARRAGE_SUMMONER.get(), level, caster);
        this.element = element;
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)this.element.ordinal());
        this.damageMultiplier = 0.8f;
        this.maxLivingTicks = 20;
    }

    public EnumElement getElement() {
        return this.element;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int i;
        super.m_7350_(key);
        if (key == ELEMENT_DATA && (i = ((Integer)this.f_19804_.m_135370_(ELEMENT_DATA)).intValue()) < EnumElement.values().length) {
            this.element = EnumElement.values()[i];
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELEMENT_DATA, (Object)0);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)compound.m_128451_("Element"));
        try {
            this.element = EnumElement.values()[(Integer)this.f_19804_.m_135370_(ELEMENT_DATA)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Element", ((Integer)this.f_19804_.m_135370_(ELEMENT_DATA)).intValue());
    }

    @Override
    protected void summonProjectiles() {
        EntityElementalBall spellBall = new EntityElementalBall(this.f_19853_, this.getOwner(), this.element);
        spellBall.withMaxLivingTicks(30);
        spellBall.setDamageMultiplier(this.damageMultiplier);
        spellBall.m_6034_(spellBall.m_20185_() + (double)this.f_19796_.nextFloat() * 1.5 - 0.75, spellBall.m_20186_() + (double)this.f_19796_.nextFloat() * 0.05 - 0.1, spellBall.m_20189_() + (double)this.f_19796_.nextFloat() * 1.5 - 0.75);
        spellBall.shootAtPosition(this.targetX, this.targetY, this.targetZ, 0.3f, 8.0f);
        this.f_19853_.m_7967_((Entity)spellBall);
        if (this.getOwner() != null) {
            switch (this.element) {
                case FIRE: {
                    this.getOwner().m_5496_((SoundEvent)ModSounds.SPELL_GENERIC_POOF.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                    break;
                }
                case WATER: {
                    this.getOwner().m_5496_((SoundEvent)ModSounds.SPELL_GENERIC_WATERBUBBLE.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
            }
        }
    }
}

