/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalTrail;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityWindBlade;
import io.github.flemmli97.runecraftory.common.entities.misc.ProjectileSummonHelperEntity;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ElementalCircleSummoner
extends ProjectileSummonHelperEntity {
    private EnumElement element = EnumElement.NONE;

    public ElementalCircleSummoner(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ElementalCircleSummoner(Level level, LivingEntity caster, EnumElement element) {
        super((EntityType)ModEntities.ELEMENTAL_CIRCLE_SUMMONER.get(), level, caster);
        this.damageMultiplier = 0.8f;
        this.maxLivingTicks = 38;
        this.element = element;
    }

    @Override
    protected void summonProjectiles() {
        float rot = this.m_146908_() + (float)((this.f_19797_ - 2) * 10);
        switch (this.element) {
            case WIND: {
                EntityWindBlade proj = new EntityWindBlade(this.f_19853_, this.getOwner());
                proj.setType(EntityWindBlade.Type.PLAIN);
                proj.setDamageMultiplier(this.damageMultiplier);
                proj.shoot(this, 0.0f, rot, 0.0f, 0.32f, 0.0f);
                proj.m_6034_(proj.m_20185_(), this.m_20186_(), proj.m_20189_());
                this.f_19853_.m_7967_((Entity)proj);
                this.m_5496_((SoundEvent)ModSounds.SPELL_GENERIC_WIND.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                break;
            }
            case FIRE: 
            case DARK: 
            case WATER: 
            case EARTH: {
                EntityElementalTrail proj = new EntityElementalTrail(this.f_19853_, this.getOwner(), this.element);
                proj.setDamageMultiplier(this.damageMultiplier);
                proj.shoot(this, 0.0f, rot, 0.0f, 0.32f, 0.0f);
                proj.withMaxLiving(40);
                double y = this.m_20186_();
                if (this.element == EnumElement.WATER || this.element == EnumElement.EARTH) {
                    y -= 0.5;
                }
                proj.m_6034_(proj.m_20185_(), y, proj.m_20189_());
                this.f_19853_.m_7967_((Entity)proj);
                this.m_5496_((SoundEvent)ModSounds.SPELL_GENERIC_FIRE_BALL.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.element = EnumElement.values()[compound.m_128451_("Element")];
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Element", this.element.ordinal());
    }
}

