/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityAmbrosiaWave
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> MAX_TICK = SynchedEntityData.m_135353_(EntityAmbrosiaWave.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final List<Vector3f> CIRCLE_PARTICLE_MOTION = RayTraceUtils.rotatedVecs((Vec3)new Vec3(0.25, 0.0, 0.0), (Vec3)new Vec3(0.0, 1.0, 0.0), (float)-180.0f, (float)175.0f, (float)5.0f);
    private final Set<FrozenEntity> hitEntityPos = new HashSet<FrozenEntity>();

    public EntityAmbrosiaWave(EntityType<? extends EntityAmbrosiaWave> type, Level level) {
        super(type, level);
        this.damageMultiplier = 0.3f;
    }

    public EntityAmbrosiaWave(Level level, LivingEntity shooter, int maxLivingTick) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.AMBROSIA_WAVE.get()), level, shooter);
        this.f_19804_.m_135381_(MAX_TICK, (Object)maxLivingTick);
        this.damageMultiplier = 0.3f;
    }

    public float radiusIncrease() {
        return 0.5f;
    }

    public double maxRadius() {
        return 5.0;
    }

    public int livingTickMax() {
        return (Integer)this.f_19804_.m_135370_(MAX_TICK);
    }

    public boolean canStartDamage() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAX_TICK, (Object)140);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.livingTicks < (Integer)this.f_19804_.m_135370_(MAX_TICK) - 8 && this.livingTicks % 5 == 1) {
                for (Vector3f vec : CIRCLE_PARTICLE_MOTION) {
                    this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.STATIC_LIGHT.get(), 0.78431374f, 0.52156866f, 0.14117648f, 1.0f, 0.4f), this.m_20185_(), this.m_20186_() + 0.2, this.m_20189_(), (double)vec.m_122239_(), (double)vec.m_122260_(), (double)vec.m_122269_());
                }
            }
        } else {
            if (this.canStartDamage()) {
                this.m_5496_((SoundEvent)ModSounds.ENTITY_AMBROSIA_WAVE.get(), 1.0f, 1.0f);
            }
            if (this.m_142480_() != null && !this.m_142480_().m_6084_()) {
                this.m_146870_();
            }
            this.hitEntityPos.forEach(frozenEntity -> {
                LivingEntity patt3506$temp = frozenEntity.entity;
                if (patt3506$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt3506$temp;
                    player.m_6027_(frozenEntity.pos.m_7096_(), frozenEntity.pos.m_7098_(), frozenEntity.pos.m_7094_());
                } else {
                    frozenEntity.entity.m_6034_(frozenEntity.pos.m_7096_(), frozenEntity.pos.m_7098_(), frozenEntity.pos.m_7094_());
                }
            });
        }
    }

    @Override
    protected boolean canHit(LivingEntity e) {
        return super.canHit(e) && e.m_20280_((Entity)this) <= (double)(this.getRadius() * this.getRadius());
    }

    protected AABB damageBoundingBox() {
        float radius = this.getRadius();
        return this.m_142469_().m_82377_((double)radius, 0.75, (double)radius);
    }

    protected boolean damageEntity(LivingEntity e) {
        CustomDamage.Builder builder = new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().hurtResistant(5).element(EnumElement.EARTH).withChangedAttribute((Attribute)ModAttributes.DRAIN.get(), 50.0);
        if (CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)e, builder, CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            e.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 10, 6, true, false));
            this.hitEntityPos.add(new FrozenEntity(e, e.m_20182_()));
            return true;
        }
        return false;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MAX_TICK, (Object)compound.m_128451_("MaxTick"));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MaxTick", ((Integer)this.f_19804_.m_135370_(MAX_TICK)).intValue());
    }

    record FrozenEntity(LivingEntity entity, Vec3 pos) {
        @Override
        public boolean equals(Object obj) {
            if (obj instanceof FrozenEntity) {
                FrozenEntity frozenEntity = (FrozenEntity)obj;
                return this.entity == frozenEntity.entity;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.entity.m_142081_().hashCode();
        }
    }
}

