/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityAppleProjectile
extends BaseProjectile {
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(EntityAppleProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean circling;
    private int angleOffset;
    private int circleTime;

    public EntityAppleProjectile(EntityType<? extends BaseProjectile> type, Level world) {
        super(type, world);
    }

    public EntityAppleProjectile(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.APPLE.get()), world, shooter);
    }

    public void setAngleOffset(int angleOffset) {
        this.angleOffset = angleOffset;
    }

    public void setCircling(boolean circling, int circleTime) {
        this.circling = circling;
        this.circleTime = circleTime;
    }

    public void withSizeInc(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    public int livingTickMax() {
        return 400;
    }

    public float radius() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.0f));
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(SIZE)).floatValue() + 1.0f;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            --this.circleTime;
            Entity owner = this.m_37282_();
            if (owner == null) {
                this.m_146870_();
            } else if (this.circling) {
                if (this.circleTime > 0) {
                    Vec3 ownerPos = owner.m_20182_();
                    double[] pos = MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)((double)owner.m_20205_() + 0.5), (double)0.0, (double)0.0, (float)((float)Math.PI / 180 * (float)(13 * this.livingTicks + this.angleOffset)));
                    this.m_20334_(ownerPos.f_82479_ + pos[0] - this.m_20185_(), ownerPos.f_82480_ + (double)this.m_37282_().m_20206_() * 0.25 - this.m_20186_(), ownerPos.f_82481_ + pos[2] - this.m_20189_());
                    this.f_19812_ = true;
                } else if (this.circleTime == 0) {
                    Mob mob;
                    if (owner instanceof Mob && (mob = (Mob)owner).m_5448_() != null) {
                        this.shootAtEntity((Entity)mob.m_5448_(), 1.0f, 0.0f);
                    } else {
                        this.shoot(owner, owner.m_146909_(), owner.m_146908_(), 0.0f, 1.0f, 0.0f);
                    }
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return this.circling ? 0.005f : super.getGravityVelocity();
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).knock(CustomDamage.KnockBackType.NONE).hurtResistant(4).projectile(), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null)) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    protected void onBlockHit(BlockHitResult result) {
        if (!this.circling || this.circleTime < 0) {
            this.m_146870_();
        }
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.m_6084_()) {
            return null;
        }
        if (this.attackedEntities.isEmpty()) {
            return RayTraceUtils.rayTraceEntities((Level)this.f_19853_, (Entity)this, (Vec3)from, (Vec3)to, (AABB)this.m_142469_().m_82369_(this.m_20184_()).m_82400_(1.0), this::canHit, e -> this.radius() + 0.3f);
        }
        return null;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.circling = compound.m_128471_("Circling");
        this.circleTime = compound.m_128451_("CirclingTime");
        this.angleOffset = compound.m_128451_("AngleOffset");
        this.withSizeInc(compound.m_128457_("Size"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Circling", this.circling);
        compound.m_128405_("CirclingTime", this.circleTime);
        compound.m_128405_("AngleOffset", this.angleOffset);
        compound.m_128350_("Size", ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
    }
}

