/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBigPlate
extends BaseProjectile {
    private boolean hitSomething;

    public EntityBigPlate(EntityType<? extends EntityBigPlate> type, Level world) {
        super(type, world);
    }

    public EntityBigPlate(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.BIG_PLATE.get()), world, shooter);
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.m_6084_()) {
            return null;
        }
        return EntityBigPlate.getEntityHitResult(this, from, to, this::canHit);
    }

    private static EntityHitResult getEntityHitResult(EntityProjectile projectile, Vec3 from, Vec3 to, Predicate<Entity> pred) {
        double dY = to.m_7098_() - projectile.m_20186_();
        AABB bb = projectile.m_142469_().m_82363_(0.0, dY, 0.0);
        for (Entity e : projectile.f_19853_.m_6249_((Entity)projectile, bb.m_82400_(1.0), pred)) {
            if (!e.m_142469_().m_82400_(0.3).m_82381_(bb)) continue;
            return new EntityHitResult(e);
        }
        return null;
    }

    public boolean isPiercing() {
        return true;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).noKnockback().hurtResistant(5), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
        if (!this.hitSomething) {
            this.f_19853_.m_5594_(null, result.m_82443_().m_142538_(), SoundEvents.f_11668_, this.m_5720_(), 1.0f, 0.5f);
            this.hitSomething = true;
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        if (!this.hitSomething) {
            this.f_19853_.m_5594_(null, blockHitResult.m_82425_(), SoundEvents.f_11668_, this.m_5720_(), 1.0f, 0.5f);
        }
        this.m_146870_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hitSomething = compound.m_128471_("HitSomething");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HitSomething", this.hitSomething);
    }
}

