/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBigRaccoonLeaf
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> SPIN = SynchedEntityData.m_135353_(EntityBigRaccoonLeaf.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> INITIAL_YAW = SynchedEntityData.m_135353_(EntityBigRaccoonLeaf.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private double diameter;
    private Vec3 axis;
    private Vec3 dir;
    private Vec3 center;
    private float sumAngles;

    public EntityBigRaccoonLeaf(EntityType<? extends BaseProjectile> type, Level world) {
        super(type, world);
    }

    public EntityBigRaccoonLeaf(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.BIG_RACCOON_LEAF.get()), world, shooter);
        if (shooter.m_20206_() > 2.0f) {
            this.m_6034_(this.m_20185_(), shooter.m_20186_() + (double)shooter.m_20206_() * 0.5, this.m_20189_());
        }
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        this.f_19804_.m_135381_(INITIAL_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.dir = this.m_20184_();
        this.axis = this.m_20214_(-this.m_5686_(1.0f), -this.m_5675_(1.0f));
    }

    public void setDiameter(double diameter) {
        this.diameter = Math.max(diameter, 1.0);
    }

    public float radius() {
        return 0.5f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPIN, (Object)false);
        this.f_19804_.m_135372_(INITIAL_YAW, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return 30;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.diameter > 0.0) {
                Vec3 toCenterDir = this.dir.m_82541_().m_82490_(this.diameter * 0.5);
                if (this.center == null) {
                    this.center = this.m_20182_().m_82549_(toCenterDir);
                }
                float angle = (float)(Math.PI * 2 / (double)this.livingTickMax() * this.dir.m_82553_());
                if (!this.spinRight()) {
                    angle *= -1.0f;
                }
                if (this.sumAngles == 0.0f) {
                    this.sumAngles += angle * 3.0f;
                }
                double[] point = MathUtils.rotate((double)this.axis.f_82479_, (double)this.axis.f_82480_, (double)this.axis.f_82481_, (double)(-toCenterDir.f_82479_), (double)(-toCenterDir.f_82480_), (double)(-toCenterDir.f_82481_), (float)this.sumAngles);
                this.sumAngles += angle;
                Vec3 newPos = new Vec3(point[0], point[1], point[2]).m_82549_(this.center);
                this.m_20256_(newPos.m_82546_(this.m_20182_()));
                this.f_19812_ = true;
            }
            if ((double)this.sumAngles >= Math.PI * 2) {
                this.m_146870_();
            }
        }
    }

    public void withRightSpin(boolean spin) {
        this.f_19804_.m_135381_(SPIN, (Object)spin);
    }

    public boolean spinRight() {
        return (Boolean)this.f_19804_.m_135370_(SPIN);
    }

    public float initialYaw() {
        return ((Float)this.f_19804_.m_135370_(INITIAL_YAW)).floatValue();
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).hurtResistant(2).element(EnumElement.EARTH), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
        if (att) {
            this.m_146870_();
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.diameter = compound.m_128459_("Diameter");
        ListTag listTag = compound.m_128437_("Axis", 6);
        this.axis = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
        listTag = compound.m_128437_("Direction", 6);
        this.dir = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
        listTag = compound.m_128437_("Center", 6);
        this.center = new Vec3(listTag.m_128772_(0), listTag.m_128772_(1), listTag.m_128772_(2));
        this.sumAngles = compound.m_128457_("Angles");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128347_("Diameter", this.diameter);
        compound.m_128365_("Axis", (Tag)this.m_20063_(new double[]{this.axis.f_82479_, this.axis.f_82480_, this.axis.f_82481_}));
        compound.m_128365_("Direction", (Tag)this.m_20063_(new double[]{this.dir.f_82479_, this.dir.f_82480_, this.dir.f_82481_}));
        compound.m_128365_("Center", (Tag)this.m_20063_(new double[]{this.center.f_82479_, this.center.f_82480_, this.center.f_82481_}));
        compound.m_128347_("Angles", (double)this.sumAngles);
    }
}

