/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityBullet
extends BaseProjectile {
    private static final float[] SIN_POINTS = EntityBullet.calcSinPoints();
    private static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.m_135353_(EntityBullet.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EnumElement element = EnumElement.NONE;
    private boolean straight;
    private boolean reverse;
    private Vec3 dir;
    private Vec3 side;

    public EntityBullet(EntityType<? extends EntityBullet> type, Level level) {
        super(type, level);
    }

    public EntityBullet(Level level, LivingEntity thrower) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.CIRCLING_BULLET.get()), level, thrower);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = Mth.m_14089_((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELEMENT_DATA, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = EnumElement.values()[(Integer)this.f_19804_.m_135370_(ELEMENT_DATA)];
        }
        super.m_7350_(key);
    }

    public void setElement(EnumElement element) {
        this.element = element;
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public EnumElement element() {
        return this.element;
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        Vec3 up = this.m_20214_(-this.m_5686_(1.0f), -this.m_5675_(1.0f)).m_82541_();
        this.dir = this.m_20184_();
        this.side = new Vec3(RayTraceUtils.rotatedAround((Vec3)this.dir, (Vector3f)new Vector3f(up), (float)90.0f)).m_82541_();
    }

    public void reverseMovement() {
        this.reverse = !this.reverse;
    }

    public void setStraight() {
        this.straight = true;
    }

    public int livingTickMax() {
        return this.straight ? 20 : 50;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && !this.straight && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = this.reverse ? -SIN_POINTS[t] : SIN_POINTS[t] * 2.0f;
            this.m_20334_(this.dir.f_82479_ + this.side.f_82479_ * (double)sT, this.dir.f_82480_ + this.side.f_82480_ * (double)sT, this.dir.f_82481_ + this.side.f_82481_ * (double)sT);
            this.f_19812_ = true;
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean res = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).hurtResistant(0).element(this.element).projectile(), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
        if (res) {
            this.m_146870_();
        }
        return res;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.m_146870_();
    }
}

