/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityButterfly
extends BaseProjectile {
    protected static final EntityDataAccessor<Float> LOCKED_YAW = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> LOCKED_PITCH = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Optional<UUID>> HIT = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Float> HIT_X = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> HIT_Y = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> HIT_Z = SynchedEntityData.m_135353_(EntityButterfly.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final int DEFAULT_MAX_TICK = 50;
    private LivingEntity stuckEntity;
    private int livingTickMax = 50;

    public EntityButterfly(EntityType<? extends EntityButterfly> type, Level level) {
        super(type, level);
        this.damageMultiplier = 0.15f;
    }

    public EntityButterfly(Level level, LivingEntity thrower) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.BUTTERFLY.get()), level, thrower);
        this.damageMultiplier = 0.15f;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOCKED_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LOCKED_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HIT, Optional.empty());
        this.f_19804_.m_135372_(HIT_X, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HIT_Y, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HIT_Z, (Object)Float.valueOf(0.0f));
    }

    public int livingTickMax() {
        return this.livingTickMax;
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity stuck = this.getHitEntity();
        if (stuck != null) {
            this.m_146926_(((Float)this.f_19804_.m_135370_(LOCKED_PITCH)).floatValue());
            this.m_146922_(((Float)this.f_19804_.m_135370_(LOCKED_YAW)).floatValue());
            Vec3 pos = stuck.m_20182_().m_82520_((double)((Float)this.f_19804_.m_135370_(HIT_X)).floatValue(), (double)((Float)this.f_19804_.m_135370_(HIT_Y)).floatValue(), (double)((Float)this.f_19804_.m_135370_(HIT_Z)).floatValue());
            this.m_146884_(pos);
            if (!this.f_19853_.f_46443_ && this.livingTicks % 40 == 0 && this.m_37282_() != null) {
                Entity entity = this.m_37282_();
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    CombatUtils.applyTempAttribute(living, (Attribute)ModAttributes.DRAIN.get(), 80.0);
                }
                CustomDamage.Builder builder = new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().hurtResistant(0);
                builder.get().hurtEntity((Entity)stuck, (float)(CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier * 0.7));
                Entity entity2 = this.m_37282_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    CombatUtils.removeTempAttribute(living, (Attribute)ModAttributes.DRAIN.get());
                }
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        if (CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().hurtResistant(5), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            Entity entity = result.m_82443_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)entity;
                this.hitEntity(livingTarget);
            } else {
                this.m_146870_();
            }
            return true;
        }
        return false;
    }

    private void hitEntity(LivingEntity target) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 3));
        this.livingTickMax += 60;
        this.f_19804_.m_135381_(LOCKED_PITCH, (Object)Float.valueOf(this.m_146909_()));
        this.f_19804_.m_135381_(LOCKED_YAW, (Object)Float.valueOf(this.m_146908_()));
        this.f_19804_.m_135381_(HIT, Optional.of(target.m_142081_()));
        Vec3 dir = this.m_20182_().m_82549_(this.m_20184_().m_82490_(1.5)).m_82546_(target.m_20182_()).m_82490_(0.98);
        this.f_19804_.m_135381_(HIT_X, (Object)Float.valueOf((float)dir.m_7096_()));
        this.f_19804_.m_135381_(HIT_Y, (Object)Float.valueOf((float)dir.m_7098_()));
        this.f_19804_.m_135381_(HIT_Z, (Object)Float.valueOf((float)dir.m_7094_()));
    }

    protected void onBlockHit(BlockHitResult blockRayTraceResult) {
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(LOCKED_PITCH, (Object)Float.valueOf(compound.m_128457_("LockedPitch")));
        this.f_19804_.m_135381_(LOCKED_YAW, (Object)Float.valueOf(compound.m_128457_("LockedYaw")));
        if (compound.m_128403_("HitEntity")) {
            this.f_19804_.m_135381_(HIT, Optional.of(compound.m_128342_("HitEntity")));
        }
        this.f_19804_.m_135381_(HIT_X, (Object)Float.valueOf(compound.m_128457_("HitX")));
        this.f_19804_.m_135381_(HIT_Y, (Object)Float.valueOf(compound.m_128457_("HitY")));
        this.f_19804_.m_135381_(HIT_Z, (Object)Float.valueOf(compound.m_128457_("HitZ")));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128350_("LockedPitch", ((Float)this.f_19804_.m_135370_(LOCKED_PITCH)).floatValue());
        compound.m_128350_("LockedYaw", ((Float)this.f_19804_.m_135370_(LOCKED_YAW)).floatValue());
        ((Optional)this.f_19804_.m_135370_(HIT)).ifPresent(id -> compound.m_128362_("HitEntity", id));
        compound.m_128350_("HitX", ((Float)this.f_19804_.m_135370_(HIT_X)).floatValue());
        compound.m_128350_("HitY", ((Float)this.f_19804_.m_135370_(HIT_Y)).floatValue());
        compound.m_128350_("HitZ", ((Float)this.f_19804_.m_135370_(HIT_Z)).floatValue());
    }

    public LivingEntity getHitEntity() {
        if (this.stuckEntity != null && !this.stuckEntity.m_146910_()) {
            return this.stuckEntity;
        }
        ((Optional)this.f_19804_.m_135370_(HIT)).ifPresent(uuid -> {
            this.stuckEntity = (LivingEntity)EntityUtil.findFromUUID(LivingEntity.class, (Level)this.f_19853_, (UUID)uuid);
            this.onUpdateOwner();
        });
        return this.stuckEntity;
    }
}

