/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.items.tools.ItemToolFishingRod;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.runecraftory.mixinhelper.ExtendedFishingRodHookTrigger;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import java.util.List;
import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCustomFishingHook
extends EntityProjectile {
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.m_135353_(EntityCustomFishingHook.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean inFishingSpot;
    private boolean inSand;
    private EnumElement element = EnumElement.NONE;
    private FluidState currentFluidState;
    private int nibble;
    private int timeUntilBite;
    private float fishAngle;
    private final int luck;
    private final int lureSpeedBonus;
    private final int nibbleBonus;
    private int difficultyBonus;
    private BooleanSupplier canAttack;
    private Runnable setOnCooldown;

    public EntityCustomFishingHook(EntityType<? extends EntityCustomFishingHook> entityType, Level level) {
        super(entityType, level);
        this.luck = 0;
        this.lureSpeedBonus = 0;
        this.nibbleBonus = 0;
    }

    public EntityCustomFishingHook(Level world, LivingEntity shooter, int speed, int luck, int charge) {
        super((EntityType)ModEntities.FISHING_HOOK.get(), world, shooter);
        this.m_6034_(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_());
        this.shoot((Entity)shooter, Math.max(-90.0f, shooter.m_146909_() - 5.0f), shooter.m_146908_(), 0.0f, 1.1f + Math.max(-0.3f, Mth.m_14031_((float)(-shooter.m_146909_() * ((float)Math.PI / 180)))), 0.0f);
        this.lureSpeedBonus = speed;
        this.luck = luck;
        this.nibbleBonus = charge;
    }

    public void setElement(EnumElement element) {
        this.element = element;
    }

    public void attackHandlingPlayer(BooleanSupplier canAttack, Runnable runnable) {
        this.canAttack = canAttack;
        this.setOnCooldown = runnable;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_BITING, (Object)false);
    }

    public void m_8119_() {
        if (this.shouldStopFishing()) {
            return;
        }
        BlockPos blockPos = this.m_142538_();
        BlockState state = this.f_19853_.m_8055_(blockPos);
        BlockState below = this.f_19853_.m_8055_(new BlockPos(this.m_20182_().m_82520_(0.0, -0.2, 0.0)));
        this.currentFluidState = this.f_19853_.m_6425_(blockPos);
        float fluid = 0.0f;
        this.inSand = false;
        if (this.currentFluidState.m_205070_(FluidTags.f_13131_)) {
            fluid = this.currentFluidState.m_76155_((BlockGetter)this.f_19853_, blockPos);
        } else if (state.m_60795_() && below.m_204336_(BlockTags.f_13029_)) {
            this.inFishingSpot = true;
            this.inSand = true;
        }
        if (!this.inFishingSpot && fluid > 0.0f) {
            this.m_20256_(this.m_20184_().m_82542_(0.3, 0.2, 0.3));
            this.inFishingSpot = true;
            return;
        }
        if (this.inFishingSpot) {
            boolean canFish;
            Vec3 vec3 = this.m_20184_();
            double d = this.m_20186_() + vec3.f_82480_ - (double)blockPos.m_123342_() - (double)fluid;
            if (Math.abs(d) < 0.01) {
                d += Math.signum(d) * 0.1;
            }
            this.m_20334_(vec3.f_82479_ * 0.9, vec3.f_82480_ - d * (double)this.f_19796_.nextFloat() * 0.2, vec3.f_82481_ * 0.9);
            boolean bl = canFish = (fluid > 0.0f || this.inSand) && this.correctLocation(blockPos);
            if (canFish) {
                if (((Boolean)this.f_19804_.m_135370_(DATA_BITING)).booleanValue()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1 * (double)this.f_19796_.nextFloat() * (double)this.f_19796_.nextFloat(), 0.0));
                }
                if (!this.f_19853_.f_46443_) {
                    this.doFishing();
                }
            }
        }
        super.m_8119_();
    }

    public void moveEntity() {
        if (!this.currentFluidState.m_205070_(FluidTags.f_13131_)) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(-this.getGravityVelocity()), 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_37283_();
        if (!this.inFishingSpot && (this.f_19861_ || this.f_19862_)) {
            this.m_20256_(Vec3.f_82478_);
        }
        this.m_20256_(this.m_20184_().m_82490_((double)this.motionReduction(this.m_20069_())));
        this.m_20090_();
    }

    protected float motionReduction(boolean inWater) {
        return 0.92f;
    }

    public boolean isPiercing() {
        return true;
    }

    public int maxPierceAmount() {
        return 5;
    }

    protected boolean entityRayTraceHit(EntityHitResult entityHitResult) {
        if (this.canAttack != null && !this.canAttack.getAsBoolean()) {
            this.m_146870_();
            return false;
        }
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), entityHitResult.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_), null);
        if (att && this.setOnCooldown != null) {
            this.setOnCooldown.run();
            this.setOnCooldown = null;
            this.canAttack = null;
            Entity entity = this.m_37282_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    LevelCalc.levelSkill(player, data, EnumSkills.FISHING, 10.0f);
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 1.0f);
                });
            }
        }
        return att;
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        this.m_20256_(this.m_20184_().m_82541_().m_82490_(blockHitResult.m_82448_((Entity)this)));
    }

    public boolean m_6072_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = null;
            });
        }
    }

    public void m_142036_() {
        super.m_142036_();
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = null;
            });
        }
    }

    public void onUpdateOwner() {
        super.onUpdateOwner();
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Platform.INSTANCE.getEntityData(living).ifPresent(data -> {
                data.fishingHook = this;
            });
        }
    }

    private boolean shouldStopFishing() {
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        ItemStack itemStack = entity2.m_21205_();
        ItemStack itemStack2 = entity2.m_21206_();
        boolean bl = itemStack.m_41720_() instanceof ItemToolFishingRod;
        boolean bl2 = itemStack2.m_41720_() instanceof ItemToolFishingRod;
        if (entity2.m_146910_() || !entity2.m_6084_() || !bl && !bl2 || this.m_20280_((Entity)entity2) > 1024.0) {
            this.m_146870_();
            return true;
        }
        return false;
    }

    private boolean correctLocation(BlockPos blockPos) {
        for (int i = -1; i < 2; ++i) {
            int state = i != 1 ? 0 : 1;
            int yD = this.inSand ? i - 1 : i;
            boolean check = BlockPos.m_121990_((BlockPos)blockPos.m_142082_(-1, yD, -1), (BlockPos)blockPos.m_142082_(1, yD, 1)).allMatch(p -> this.blockCheck((BlockPos)p, state) != LocationType.INVALID);
            if (check) continue;
            return false;
        }
        return true;
    }

    private LocationType blockCheck(BlockPos blockPos, int state) {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        if (state != 0 && (blockState.m_60795_() || blockState.m_60713_(Blocks.f_50196_))) {
            return LocationType.AIR;
        }
        if (this.inSand) {
            if (state != 1 && blockState.m_204336_(BlockTags.f_13029_)) {
                return LocationType.MATCH;
            }
            return LocationType.INVALID;
        }
        FluidState fluidState = blockState.m_60819_();
        if (state != 1 && fluidState.m_205070_(FluidTags.f_13131_) && fluidState.m_76170_() && blockState.m_60812_((BlockGetter)this.f_19853_, blockPos).m_83281_()) {
            return LocationType.MATCH;
        }
        return LocationType.INVALID;
    }

    protected void doFishing() {
        Level level = this.f_19853_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilBite = 0;
                this.m_20088_().m_135381_(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilBite > 0) {
            --this.timeUntilBite;
            float splashChance = 0.15f;
            if (this.timeUntilBite < 20) {
                splashChance += (float)(20 - this.timeUntilBite) * 0.05f;
            } else if (this.timeUntilBite < 40) {
                splashChance += (float)(40 - this.timeUntilBite) * 0.02f;
            } else if (this.timeUntilBite < 60) {
                splashChance += (float)(60 - this.timeUntilBite) * 0.01f;
            }
            if (this.f_19796_.nextFloat() < splashChance) {
                float a = Mth.m_14068_((Random)this.f_19796_, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float c = Mth.m_14068_((Random)this.f_19796_, (float)25.0f, (float)60.0f);
                double x = this.m_20185_() + (double)(Mth.m_14031_((float)a) * c) * 0.1;
                double y = (float)Mth.m_14107_((double)this.m_20186_()) + 1.0f;
                double z = this.m_20189_() + (double)(Mth.m_14089_((float)a) * c) * 0.1;
                if (this.inSand) {
                    Vec3 belowPos = this.m_20182_().m_82520_(0.0, -0.2, 0.0);
                    BlockState below = this.f_19853_.m_8055_(new BlockPos(x, belowPos.f_82480_, z));
                    if (below.m_204336_(BlockTags.f_13029_)) {
                        serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, below), x, y - 0.9, z, 2 + this.f_19796_.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    }
                } else if (serverLevel.m_8055_(new BlockPos(x, y - 1.0, z)).m_60713_(Blocks.f_49990_)) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, x, y, z, 2 + this.f_19796_.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilBite > 0) {
                this.fishAngle = (float)((double)this.fishAngle + this.f_19796_.nextGaussian() * 4.0);
                float angle = this.fishAngle * ((float)Math.PI / 180);
                float g = Mth.m_14031_((float)angle);
                float h = Mth.m_14089_((float)angle);
                double y = (float)Mth.m_14107_((double)this.m_20186_()) + 1.0f;
                double z = this.m_20189_() + (double)(h * (float)this.timeUntilBite * 0.1f);
                double x = this.m_20185_() + (double)(g * (float)this.timeUntilBite * 0.1f);
                if (this.inSand) {
                    y -= 1.0;
                }
                BlockState blockState = serverLevel.m_8055_(new BlockPos(x, y - 1.0, z));
                if (this.inSand && blockState.m_60713_(Blocks.f_49992_) || !this.inSand && blockState.m_60713_(Blocks.f_49990_)) {
                    SimpleParticleType bubble = ParticleTypes.f_123795_;
                    SimpleParticleType particle = ParticleTypes.f_123795_;
                    if (this.inSand) {
                        particle = bubble = new BlockParticleOption(ParticleTypes.f_123794_, blockState);
                        y += 0.1;
                    }
                    if (this.f_19796_.nextFloat() < 0.15f) {
                        serverLevel.m_8767_((ParticleOptions)bubble, x, y - (double)0.1f, z, 1, (double)g, 0.1, (double)h, 0.0);
                    }
                    float k = g * 0.04f;
                    float l = h * 0.04f;
                    serverLevel.m_8767_((ParticleOptions)particle, x, y, z, 0, (double)l, 0.01, (double)(-k), 1.0);
                    serverLevel.m_8767_((ParticleOptions)particle, x, y, z, 0, (double)(-l), 0.01, (double)k, 1.0);
                }
            } else {
                this.m_5496_(SoundEvents.f_11940_, 0.25f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.4f);
                double m = this.m_20186_() + 0.5;
                SimpleParticleType particle = ParticleTypes.f_123795_;
                if (this.inSand) {
                    BlockState below = this.f_19853_.m_8055_(new BlockPos(this.m_20182_().m_82520_(0.0, -0.2, 0.0)));
                    particle = new BlockParticleOption(ParticleTypes.f_123794_, below);
                }
                serverLevel.m_8767_((ParticleOptions)particle, this.m_20185_(), m, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                if (!this.inSand) {
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123816_, this.m_20185_(), m, this.m_20189_(), (int)(1.0f + this.m_20205_() * 20.0f), (double)this.m_20205_(), 0.0, (double)this.m_20205_(), (double)0.2f);
                }
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123758_, this.m_20185_(), m, this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                this.difficultyBonus = Mth.m_14072_((Random)this.f_19796_, (int)0, (int)3);
                this.nibble = Mth.m_14072_((Random)this.f_19796_, (int)12, (int)(30 - this.difficultyBonus * 3)) - this.difficultyBonus * 5;
                this.nibble += this.nibbleBonus * 3;
                this.nibble = Math.max(1, this.nibble);
                this.m_20088_().m_135381_(DATA_BITING, (Object)true);
            }
        } else {
            this.fishAngle = Mth.m_14068_((Random)this.f_19796_, (float)0.0f, (float)360.0f);
            this.timeUntilBite = Mth.m_14072_((Random)this.f_19796_, (int)Math.max(5, 100 - this.lureSpeedBonus * 15), (int)Math.max(50, 600 - this.lureSpeedBonus * 75));
        }
    }

    public void retract(ItemStack stack) {
        Entity eOwner = this.m_37282_();
        if (this.f_19853_.f_46443_ || this.shouldStopFishing()) {
            return;
        }
        if (!(eOwner instanceof ServerPlayer)) {
            this.m_146870_();
            return;
        }
        ServerPlayer owner = (ServerPlayer)eOwner;
        if (this.nibble > 0) {
            float luck = (float)this.luck + owner.m_36336_() + (float)this.difficultyBonus * 0.5f + (float)Platform.INSTANCE.getPlayerData((Player)owner).map(d -> d.getSkillLevel(EnumSkills.FISHING).getLevel()).orElse(0).intValue() * 0.02f;
            LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78972_(LootContextParams.f_81455_, (Object)this).m_78977_(this.f_19796_).m_78963_(luck);
            ResourceLocation loot = this.inSand ? LootTableResources.SAND_FISHING : LootTableResources.FISHING;
            LootTable lootTable = this.f_19853_.m_142572_().m_129898_().m_79217_(loot);
            List list = lootTable.m_79129_(builder.m_78975_(LootContextParamSets.f_81414_));
            ((ExtendedFishingRodHookTrigger)CriteriaTriggers.f_10553_).runecraftory$customTrigger(owner, stack, this, list);
            for (ItemStack itemStack2 : list) {
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack2);
                double d2 = owner.m_20185_() - this.m_20185_();
                double e = owner.m_20186_() - this.m_20186_();
                double f = owner.m_20189_() - this.m_20189_();
                itemEntity.m_20334_(d2 * 0.1, e * 0.1 + Math.sqrt(Math.sqrt(d2 * d2 + e * e + f * f)) * 0.08, f * 0.1);
                this.f_19853_.m_7967_((Entity)itemEntity);
                owner.f_19853_.m_7967_((Entity)new ExperienceOrb(owner.f_19853_, owner.m_20185_(), owner.m_20186_() + 0.5, owner.m_20189_() + 0.5, this.f_19796_.nextInt(6) + 1));
                if (!itemStack2.m_204117_(ItemTags.f_13156_)) continue;
                owner.m_36222_(Stats.f_12939_, 1);
            }
            Entity entity = this.m_37282_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Platform.INSTANCE.getPlayerData((Player)player).ifPresent(data -> {
                    LevelCalc.useRP((Player)player, data, 10 * (this.nibbleBonus + 1), true, 0.0f, true, EnumSkills.FISHING);
                    LevelCalc.levelSkill(player, data, EnumSkills.FISHING, 25.0f);
                    LevelCalc.levelSkill(player, data, EnumSkills.WATER, 5.0f);
                });
            }
        }
        this.m_146870_();
    }

    static enum LocationType {
        AIR,
        MATCH,
        INVALID;

    }
}

