/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityDarkBall
extends BaseDamageCloud {
    private static final float[] SIN_POINTS = EntityDarkBall.calcSinPoints();
    private Type type = Type.BALL;
    private Vec3 dir;
    private Vec3 side;

    public EntityDarkBall(EntityType<? extends EntityDarkBall> type, Level level) {
        super(type, level);
    }

    public EntityDarkBall(Level level, LivingEntity thrower, Type type) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.DARK_BALL.get()), level, thrower);
        this.m_6034_(this.m_20185_(), this.m_20186_() + (double)thrower.m_20206_() * 0.5, this.m_20189_());
        this.type = type;
        this.setRadius(1.5f);
    }

    private static float[] calcSinPoints() {
        float[] arr = new float[16];
        float step = 0.3926991f;
        for (int i = 0; i < 16; ++i) {
            arr[i] = Mth.m_14089_((float)((float)(i + 8) * step)) * 0.2f;
        }
        return arr;
    }

    public void shootAtPos(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.m_7096_() - this.m_20185_(), targetPos.m_7098_() - this.m_20186_(), targetPos.m_7094_() - this.m_20189_());
        this.shoot(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(throwerMotion.f_82479_, entityThrower.m_20096_() ? 0.0 : throwerMotion.f_82480_, throwerMotion.f_82481_));
        this.m_20184_().m_82520_(throwerMotion.f_82479_, 0.0, throwerMotion.f_82481_);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((Vec3)vector3d));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        Vec3 up = this.m_20214_(-this.m_5686_(1.0f), -this.m_5675_(1.0f)).m_82541_();
        this.dir = this.m_20184_();
        this.side = new Vec3(RayTraceUtils.rotatedAround((Vec3)this.dir, (Vector3f)new Vector3f(up), (float)90.0f)).m_82541_();
    }

    public int livingTickMax() {
        return this.type == Type.BALL ? 100 : 60;
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
        if (this.f_19853_.f_46443_) {
            int i;
            for (i = 0; i < 5; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.SHORT_LIGHT.get(), 0.25490198f, 0.007843138f, 0.4117647f, 0.2f, 5.5f), this.m_20185_() + this.f_19796_.nextGaussian() * 0.15, this.m_20186_() + this.f_19796_.nextGaussian() * 0.07, this.m_20189_() + this.f_19796_.nextGaussian() * 0.15, this.f_19796_.nextGaussian() * 0.01, Math.abs(this.f_19796_.nextGaussian() * 0.03), this.f_19796_.nextGaussian() * 0.01);
            }
            for (i = 0; i < 3; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.SHORT_LIGHT.get(), 0.6666667f, 0.3647059f, 0.83137256f, 0.2f, 5.5f), this.m_20185_() + this.f_19796_.nextGaussian() * 0.15, this.m_20186_() + this.f_19796_.nextGaussian() * 0.07, this.m_20189_() + this.f_19796_.nextGaussian() * 0.15, this.f_19796_.nextGaussian() * 0.01, Math.abs(this.f_19796_.nextGaussian() * 0.03), this.f_19796_.nextGaussian() * 0.01);
            }
        } else if (this.type == Type.SNAKE && this.dir != null && this.side != null) {
            int t = this.livingTicks % 16;
            float sT = SIN_POINTS[t];
            this.m_20334_(this.dir.f_82479_ + this.side.f_82479_ * (double)sT, this.dir.f_82480_ + this.side.f_82480_ * (double)sT, this.dir.f_82481_ + this.side.f_82481_ * (double)sT);
            this.f_19812_ = true;
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().hurtResistant(10).element(EnumElement.DARK), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        try {
            this.type = Type.valueOf(compound.m_128461_("Type"));
        }
        catch (IllegalArgumentException e) {
            this.type = Type.BALL;
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.type.toString());
    }

    public static enum Type {
        BALL,
        SNAKE;

    }
}

