/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityElementalBall
extends BaseProjectile {
    protected static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.m_135353_(EntityElementalBall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityElementalBall.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private EnumElement element = EnumElement.NONE;
    private int maxLivingTicks = 6;

    public EntityElementalBall(EntityType<? extends EntityElementalBall> type, Level world) {
        super(type, world);
    }

    public EntityElementalBall(Level world, LivingEntity shooter, EnumElement element) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.ELEMENTAL_BALL.get()), world, shooter);
        this.element = element;
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)this.element.ordinal());
        this.damageMultiplier = 0.8f;
    }

    public EnumElement getElement() {
        return this.element;
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void withMaxLivingTicks(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        int i;
        super.m_7350_(key);
        if (key == ELEMENT_DATA && (i = ((Integer)this.f_19804_.m_135370_(ELEMENT_DATA)).intValue()) < EnumElement.values().length) {
            this.element = EnumElement.values()[i];
        }
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELEMENT_DATA, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().element(this.element).hurtResistant(5), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
        this.m_146870_();
        this.playHitSound();
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.m_146870_();
        this.playHitSound();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)compound.m_128451_("Element"));
        this.f_19804_.m_135381_(VARIANT, (Object)compound.m_128451_("Variant"));
        this.maxLivingTicks = compound.m_128451_("MaxLivingTicks");
        int i = (Integer)this.f_19804_.m_135370_(ELEMENT_DATA);
        if (i < EnumElement.values().length) {
            this.element = EnumElement.values()[i];
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Element", this.element.ordinal());
        compound.m_128405_("Variant", ((Integer)this.f_19804_.m_135370_(VARIANT)).intValue());
        compound.m_128405_("MaxLivingTicks", this.maxLivingTicks);
    }

    protected void playHitSound() {
        if (this.element == EnumElement.WATER) {
            SoundEvent event = this.getVariant() == 1 ? SoundEvents.f_11913_ : (SoundEvent)ModSounds.SPELL_GENERIC_WATER.get();
            this.m_5496_(event, this.getVariant() == 1 ? 0.9f : 0.35f, 1.0f);
        }
    }
}

