/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityElementalTrail
extends BaseDamageCloud {
    private static final EntityDataAccessor<Integer> ELEMENT_DATA = SynchedEntityData.m_135353_(EntityElementalTrail.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> STATIONARY = SynchedEntityData.m_135353_(EntityElementalTrail.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private EnumElement element = EnumElement.NONE;
    private boolean piercing = true;
    private boolean hasKnockback;
    private boolean homing;
    private LivingEntity targetMob;
    private int livingTicksMax = 100;

    public EntityElementalTrail(EntityType<? extends EntityElementalTrail> type, Level level) {
        super(type, level);
    }

    public EntityElementalTrail(Level level, LivingEntity thrower, EnumElement element) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.ELEMENTAL_TRAIL.get()), level, thrower);
        this.m_6034_(this.m_20185_(), this.m_20186_() + (double)thrower.m_20206_() * 0.5, this.m_20189_());
        this.setElement(element);
        this.setRadius(0.5f);
    }

    public void shootAtEntity(Vec3 targetPos, float velocity, float inaccuracy) {
        Vec3 dir = new Vec3(targetPos.m_7096_() - this.m_20185_(), targetPos.m_7098_() - this.m_20186_(), targetPos.m_7094_() - this.m_20189_());
        this.shoot(dir.f_82479_, dir.f_82480_, dir.f_82481_, velocity, inaccuracy);
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(rotationYawIn * ((float)Math.PI / 180))) * Mth.m_14089_((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.shoot(f, f1, f2, velocity, inaccuracy);
        Vec3 throwerMotion = entityThrower.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(throwerMotion.f_82479_, entityThrower.m_20096_() ? 0.0 : throwerMotion.f_82480_, throwerMotion.f_82481_));
        this.m_20184_().m_82520_(throwerMotion.f_82479_, 0.0, throwerMotion.f_82481_);
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        Vec3 vector3d = new Vec3(x, y, z).m_82541_().m_82520_(this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.f_19796_.nextGaussian() * (double)0.0075f * (double)inaccuracy).m_82490_((double)velocity);
        this.m_20256_(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((Vec3)vector3d));
        this.m_146922_((float)(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    protected void setElement(EnumElement element) {
        this.element = element;
        this.f_19804_.m_135381_(ELEMENT_DATA, (Object)this.element.ordinal());
    }

    public EnumElement element() {
        return this.element;
    }

    public void setStationary(boolean stationary) {
        this.f_19804_.m_135381_(STATIONARY, (Object)stationary);
    }

    public void setPiercing(boolean piercing) {
        this.piercing = piercing;
    }

    public void knockback() {
        this.hasKnockback = true;
    }

    public void homing() {
        this.homing = true;
    }

    public void withMaxLiving(int livingTicksMax) {
        this.livingTicksMax = livingTicksMax;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(ELEMENT_DATA)) {
            this.element = EnumElement.values()[(Integer)this.f_19804_.m_135370_(ELEMENT_DATA)];
        }
        super.m_7350_(key);
    }

    public int livingTickMax() {
        return this.livingTicksMax;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ELEMENT_DATA, (Object)0);
        this.f_19804_.m_135372_(STATIONARY, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!((Boolean)this.f_19804_.m_135370_(STATIONARY)).booleanValue()) {
            Vec3 motion = this.m_20184_();
            double newX = this.m_20185_() + motion.f_82479_;
            double newY = this.m_20186_() + motion.f_82480_;
            double newZ = this.m_20189_() + motion.f_82481_;
            this.m_6034_(newX, newY, newZ);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.homing) {
                if (this.targetMob == null || this.targetMob.m_21224_()) {
                    this.targetMob = EntityUtils.ownedProjectileTarget(this.m_142480_(), 10);
                } else {
                    Vec3 dir = this.targetMob.m_20182_().m_82546_(this.m_20182_());
                    if (dir.m_82556_() > 0.0484) {
                        dir = dir.m_82541_().m_82490_(0.22);
                    }
                    this.m_20256_(dir);
                    this.f_19812_ = true;
                }
            }
        } else if (this.livingTicks % 2 == 0) {
            if (this.element == EnumElement.WATER) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 0.9f, 0.8f, false);
            }
            if (this.element == EnumElement.EARTH) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_144206_, this.m_5720_(), 2.0f, 0.8f, false);
            }
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        if (CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().hurtResistant(10).element(this.element), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            if (this.hasKnockback) {
                target.m_147240_(0.5, this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
            }
            if (!this.piercing) {
                this.m_146870_();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        try {
            this.setElement(EnumElement.values()[compound.m_128451_("Element")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.f_19804_.m_135381_(STATIONARY, (Object)compound.m_128471_("Stationary"));
        this.piercing = compound.m_128471_("Piercing");
        this.hasKnockback = compound.m_128471_("Knockback");
        this.homing = compound.m_128471_("Homing");
        this.livingTicksMax = compound.m_128451_("LivingTicksMax");
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Element", this.element.ordinal());
        compound.m_128379_("Stationary", ((Boolean)this.f_19804_.m_135370_(STATIONARY)).booleanValue());
        compound.m_128379_("Piercing", this.piercing);
        compound.m_128379_("Knockback", this.hasKnockback);
        compound.m_128379_("Homing", this.homing);
        compound.m_128405_("LivingTicksMax", this.livingTicksMax);
    }
}

