/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityExplosionSpell
extends BaseProjectile {
    public EntityExplosionSpell(EntityType<? extends EntityExplosionSpell> type, Level level) {
        super(type, level);
    }

    public EntityExplosionSpell(Level level, LivingEntity shooter) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.EXPLOSION.get()), level, shooter);
        this.f_19797_ = 5;
    }

    public int livingTickMax() {
        return 15;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            Vec3 dir = this.m_20184_().m_82490_(0.5);
            this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.LIGHT.get(), 0.9647059f, 0.20392157f, 0.20392157f, 0.5f, 3.0f), this.m_20185_() + dir.m_7096_(), this.m_20186_() + dir.m_7098_(), this.m_20189_() + dir.m_7094_(), 0.0, 0.0, 0.0);
            this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.LIGHT.get(), 0.9647059f, 0.20392157f, 0.20392157f, 0.5f, 3.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    protected float getGravityVelocity() {
        return 0.0025f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        this.doExplosion(result.m_82443_().m_20185_(), result.m_82443_().m_20186_(), result.m_82443_().m_20189_(), result.m_82443_());
        return true;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.doExplosion(result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, null);
    }

    private void doExplosion(double x, double y, double z, Entity hit) {
        this.doExplosion(hit);
        this.f_19853_.m_6263_(null, x, y, z, SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f);
        this.m_146870_();
        S2CScreenShake.sendAround(this.f_19853_, new Vec3(x, y, z), 16.0, 8, 2.0f);
    }

    protected void doExplosion(Entity hit) {
        if (hit != null) {
            CombatUtils.damageWithFaintAndCrit(this.m_37282_(), hit, new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().element(EnumElement.FIRE).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(1.0f), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
        }
        List list = this.f_19853_.m_45933_((Entity)this, new AABB(-5.0, -5.0, -5.0, 5.0, 5.0, 5.0).m_82383_(this.m_20182_()));
        for (Entity e : list) {
            double dist = e.m_20280_((Entity)this);
            if (dist > 25.0 || e != hit && !this.canHit(e)) continue;
            float dmgPerc = dist > 20.0 ? 0.6f : (dist > 13.0 ? 0.8f : 1.0f);
            CombatUtils.damageWithFaintAndCrit(this.m_37282_(), e, new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().element(EnumElement.FIRE).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(1.0f), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier * (double)dmgPerc, null);
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 1.0, 0.0, 0.0, 1.0);
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.damageMultiplier = compound.m_128457_("DamageMultiplier");
    }
}

