/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class EntityFireball
extends BaseProjectile {
    private static final EntityDataAccessor<Boolean> BIG = SynchedEntityData.m_135353_(EntityFireball.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityFireball(EntityType<? extends EntityFireball> type, Level level) {
        super(type, level);
    }

    public EntityFireball(Level level, LivingEntity shooter, boolean big) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.FIRE_BALL.get()), level, shooter);
        this.f_19804_.m_135381_(BIG, (Object)big);
    }

    public boolean big() {
        return (Boolean)this.f_19804_.m_135370_(BIG);
    }

    public int livingTickMax() {
        return 30;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BIG, (Object)false);
    }

    protected float getGravityVelocity() {
        return 0.0025f;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).magic().noKnockback().element(EnumElement.FIRE).hurtResistant(4), CombatUtils.getAttributeValue(this.m_37282_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
        this.f_19853_.m_5594_(null, result.m_82443_().m_142538_(), SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f);
        this.m_146870_();
        return att;
    }

    protected void onBlockHit(BlockHitResult result) {
        this.f_19853_.m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, SoundEvents.f_11913_, this.m_5720_(), 1.0f, 1.0f);
        this.m_146870_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(BIG, (Object)compound.m_128471_("Big"));
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Big", this.big());
    }
}

