/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class EntityFurniture
extends BaseProjectile {
    private static final EntityDataAccessor<Integer> FURNITURE_TYPE_SYNC = SynchedEntityData.m_135353_(EntityFurniture.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Type furnitureType = Type.CHEST;
    private float randomRotationOffset;

    public EntityFurniture(EntityType<? extends EntityFurniture> type, Level world) {
        super(type, world);
        this.randomRotationOffset = this.f_19796_.nextFloat() * 360.0f;
        this.setFurnitureType(Type.WOOLYPLUSH);
    }

    public EntityFurniture(Level world, LivingEntity shooter, Type furnitureType) {
        super((EntityType<? extends BaseProjectile>)((EntityType)ModEntities.FURNITURE.get()), world, shooter);
        this.setFurnitureType(furnitureType);
    }

    public int livingTickMax() {
        return this.m_20068_() ? 300 : 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FURNITURE_TYPE_SYNC, (Object)0);
    }

    protected float getGravityVelocity() {
        return this.m_20068_() ? 0.0f : 0.1f;
    }

    protected float motionReduction(boolean inWater) {
        return this.m_20068_() ? 1.0f : super.motionReduction(inWater);
    }

    public float getRandomRotationOffset() {
        return this.randomRotationOffset;
    }

    protected boolean entityRayTraceHit(EntityHitResult result) {
        this.m_6210_();
        boolean att = CombatUtils.damageWithFaintAndCrit(this.m_37282_(), result.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_37282_()).hurtResistant(4).element(EnumElement.DARK), CombatUtils.getAttributeValue(this.m_37282_(), Attributes.f_22281_) * (double)this.damageMultiplier, null);
        if (att) {
            this.m_146870_();
        }
        return att;
    }

    protected EntityHitResult getEntityHit(Vec3 from, Vec3 to) {
        if (!this.m_6084_()) {
            return null;
        }
        return this.entityCollision(from, to, this::canHit);
    }

    private EntityHitResult entityCollision(Vec3 from, Vec3 to, Predicate<Entity> pred) {
        double distVar = Double.MAX_VALUE;
        Entity ret = null;
        AABB entityBB = this.m_142469_();
        for (Entity entity1 : this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82400_(0.5).m_82369_(this.m_20184_()), pred)) {
            double dist;
            AABB axisalignedbb = entity1.m_142469_().m_82400_((double)0.33f);
            if (!entityBB.m_82381_(axisalignedbb) || !((dist = this.m_20182_().m_82557_(entity1.m_20182_())) < distVar)) continue;
            ret = entity1;
            distVar = dist;
        }
        return ret == null ? null : new EntityHitResult(ret);
    }

    protected void onBlockHit(BlockHitResult blockHitResult) {
        if (!this.m_20068_() && blockHitResult.m_82434_() == Direction.UP) {
            this.m_146870_();
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == FURNITURE_TYPE_SYNC) {
            this.m_6210_();
            int id = (Integer)this.f_19804_.m_135370_(FURNITURE_TYPE_SYNC);
            if (id >= 0 && id < Type.values().length) {
                this.furnitureType = Type.values()[id];
            }
        }
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20398_((float)(this.furnitureType.range * 2.0f), (float)(this.furnitureType.range * 2.0f));
    }

    public Type getFurnitureType() {
        return this.furnitureType;
    }

    protected void setFurnitureType(Type furnitureType) {
        this.furnitureType = furnitureType;
        this.f_19804_.m_135381_(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
        this.m_6210_();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        try {
            this.furnitureType = Type.valueOf(compound.m_128461_("Type"));
        }
        catch (IllegalArgumentException e) {
            this.furnitureType = Type.CHEST;
        }
        this.f_19804_.m_135381_(FURNITURE_TYPE_SYNC, (Object)this.furnitureType.ordinal());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Type", this.furnitureType.toString());
    }

    public static enum Type {
        CHEST(0.5f),
        BARREL(0.5f),
        ANVIL(0.5f),
        CHAIR(0.4f),
        WOOLYPLUSH(0.4f),
        CHIPSQUEEKPLUSH(0.4f);

        final float range;

        private Type(float range) {
            this.range = range;
        }
    }
}

