/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import com.mojang.math.Vector3f;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityElementalBall;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityGustRocks
extends BaseDamageCloud {
    private Vec3 up;
    private Vec3 side;

    public EntityGustRocks(EntityType<? extends EntityGustRocks> type, Level world) {
        super(type, world);
    }

    public EntityGustRocks(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.GUST_ROCK.get()), world, shooter);
    }

    public int livingTickMax() {
        return 28;
    }

    public boolean canStartDamage() {
        return this.livingTicks > 4;
    }

    public void setDirection(float pitch, float yaw) {
        this.m_146922_(pitch);
        this.m_146926_(yaw);
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void setDirection(double x, double y, double z) {
        Vec3 vector3d = new Vec3(x, y, z);
        double f = Math.sqrt(EntityProjectile.horizontalMag((Vec3)vector3d));
        this.m_146922_((float)(-(Mth.m_14136_((double)vector3d.f_82479_, (double)vector3d.f_82481_) * 57.2957763671875)));
        this.m_146926_((float)(Mth.m_14136_((double)vector3d.f_82480_, (double)f) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.up == null) {
            this.up = new Vec3(0.0, 1.0, 0.0).m_82490_(8.0);
            this.side = new Vec3(RayTraceUtils.rotatedAround((Vec3)this.m_20154_(), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), (float)90.0f)).m_82541_().m_82490_(12.0);
        }
        Vec3 pos = this.m_20182_();
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 16; ++i) {
                double randX = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 14.0;
                double randY = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 14.0;
                double randZ = (this.f_19796_.nextDouble() * 2.0 - 1.0) * 14.0;
                Vec3 pos2 = pos.m_82520_(randX, randY, randZ);
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.WIND.get(), 1.0f, 1.0f, 1.0f, 1.0f, 0.15f), pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_(), this.m_20154_().m_7096_(), this.m_20154_().m_7098_(), this.m_20154_().m_7094_());
            }
        } else {
            for (int i = 0; i < 2; ++i) {
                Entity entity = this.m_142480_();
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)entity;
                EntityElementalBall spellBall = new EntityElementalBall(this.f_19853_, living, EnumElement.EARTH);
                spellBall.withMaxLivingTicks(40);
                spellBall.setDamageMultiplier(this.damageMultiplier);
                double upScale = this.f_19796_.nextDouble();
                double sideScale = this.f_19796_.nextDouble() * 2.0 - 1.0;
                Vec3 pos2 = pos.m_82549_(this.m_20154_().m_82490_(-8.0)).m_82549_(this.up.m_82490_(upScale)).m_82549_(this.side.m_82490_(sideScale));
                spellBall.m_6034_(pos2.m_7096_(), pos2.m_7098_(), pos2.m_7094_());
                spellBall.m_6686_(this.m_20154_().f_82479_, -0.28, this.m_20154_().f_82481_, 0.9f, 0.0f);
                this.f_19853_.m_7967_((Entity)spellBall);
            }
        }
    }

    protected boolean damageEntity(LivingEntity livingEntity) {
        Vec3 mot = this.m_20154_().m_82490_(0.35);
        livingEntity.m_5997_(mot.m_7096_(), mot.m_7098_(), mot.m_7094_());
        livingEntity.f_19864_ = true;
        return false;
    }

    protected AABB damageBoundingBox() {
        return super.damageBoundingBox().m_82377_(16.0, 16.0, 16.0);
    }
}

