/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityHomingEnergyOrb
extends BaseDamageCloud
implements PowerableMob {
    private Vec3 spawnPos;
    private LivingEntity targetMob;
    protected static final EntityDataAccessor<Optional<UUID>> TARGET_UUID = SynchedEntityData.m_135353_(EntityHomingEnergyOrb.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public EntityHomingEnergyOrb(EntityType<? extends BaseDamageCloud> type, Level world) {
        super(type, world);
        this.setRadius(0.5f);
    }

    public EntityHomingEnergyOrb(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.ENERGY_ORB.get()), world, shooter);
        this.m_6034_(this.m_20185_(), this.m_20186_() + (double)shooter.m_20206_() * 0.5, this.m_20189_());
        this.setRadius(0.5f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_UUID, Optional.empty());
    }

    public int livingTickMax() {
        return 100;
    }

    protected boolean damageEntity(LivingEntity target) {
        return CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, new CustomDamage.Builder((Entity)this, this.m_142480_()).damageType(CustomDamage.DamageType.IGNOREMAGICDEF).noKnockback().hurtResistant(7).element(EnumElement.LIGHT), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
        if (this.spawnPos == null) {
            this.spawnPos = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.5, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.targetMob == null || this.targetMob.m_21224_()) {
                this.targetMob = EntityUtils.ownedProjectileTarget(this.m_142480_(), 10);
                if (this.targetMob != null) {
                    this.f_19804_.m_135381_(TARGET_UUID, Optional.of(this.targetMob.m_142081_()));
                } else {
                    this.f_19804_.m_135381_(TARGET_UUID, Optional.empty());
                }
            } else {
                Vec3 dir = this.targetMob.m_20182_().m_82520_(0.0, (double)this.targetMob.m_20206_() * 0.5, 0.0).m_82546_(this.m_20182_());
                if (dir.m_82556_() > 0.0729) {
                    dir = dir.m_82541_().m_82490_(0.27);
                }
                this.m_20256_(dir);
                this.f_19812_ = true;
            }
        } else if (this.f_19796_.nextBoolean()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12001_, this.m_5720_(), 2.0f, 0.8f, false);
        }
    }

    public LivingEntity getTargetMob() {
        if (this.targetMob != null && !this.targetMob.m_146910_()) {
            return this.targetMob;
        }
        ((Optional)this.f_19804_.m_135370_(TARGET_UUID)).ifPresent(uuid -> {
            this.targetMob = (LivingEntity)EntityUtil.findFromUUID(LivingEntity.class, (Level)this.f_19853_, (UUID)uuid);
        });
        return this.targetMob;
    }

    public Vec3 rootPosition(float partialTicks) {
        if (this.m_142480_() != null) {
            Entity owner = this.m_142480_();
            double x = Mth.m_14139_((double)partialTicks, (double)owner.f_19790_, (double)owner.m_20185_());
            double y = Mth.m_14139_((double)partialTicks, (double)owner.f_19791_, (double)owner.m_20186_()) + (double)owner.m_20206_() * 0.5;
            double z = Mth.m_14139_((double)partialTicks, (double)owner.f_19792_, (double)owner.m_20189_());
            return new Vec3(x, y, z);
        }
        return this.spawnPos;
    }

    public boolean m_7090_() {
        return true;
    }
}

