/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityLightBall
extends BaseDamageCloud {
    private Type lightType = Type.LONG;
    private Vec3 spawnPos;
    private float angleOffset;
    private int firstDmg = -1;

    public EntityLightBall(EntityType<? extends EntityLightBall> type, Level level) {
        super(type, level);
    }

    public EntityLightBall(Level level, LivingEntity thrower) {
        super((EntityType<? extends BaseDamageCloud>)((EntityType)ModEntities.LIGHT_BALL.get()), level, thrower);
        this.setRadius(0.8f);
    }

    public static void createFrontLights(Level level, LivingEntity thrower, float dmgMod) {
        if (level.f_46443_) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            EntityLightBall ball = new EntityLightBall(level, thrower);
            ball.setDamageMultiplier(dmgMod);
            ball.lightType = Type.FRONT;
            ball.setAngleOffset(i == 0 ? -15.0f : 15.0f);
            level.m_7967_((Entity)ball);
        }
    }

    public static void createLights(Level level, LivingEntity thrower, Type type, float dmgMod, int amount) {
        if (level.f_46443_) {
            return;
        }
        float angle = 360.0f / (float)amount;
        for (int i = 0; i < amount; ++i) {
            EntityLightBall ball = new EntityLightBall(level, thrower);
            ball.setDamageMultiplier(dmgMod);
            ball.lightType = type;
            ball.setAngleOffset(angle * (float)i);
            level.m_7967_((Entity)ball);
        }
    }

    public void setAngleOffset(float angleOffset) {
        this.angleOffset = angleOffset;
    }

    public int maxHitCount() {
        return this.lightType == Type.FRONT ? 5 : -1;
    }

    public int livingTickMax() {
        return switch (this.lightType) {
            default -> throw new IncompatibleClassChangeError();
            case Type.EXPAND -> 30;
            case Type.PIERCING_SHORT -> 140;
            case Type.PIERCING_LONG -> 240;
            case Type.LONG, Type.FRONT -> 144000;
        };
    }

    public boolean canStartDamage() {
        return this.firstDmg == -1 || (this.livingTicks - this.firstDmg) % 5 == 0;
    }

    protected AABB damageBoundingBox() {
        return this.m_142469_().m_82377_(0.25, 0.25, 0.25);
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 motion = this.m_20184_();
        double newX = this.m_20185_() + motion.f_82479_;
        double newY = this.m_20186_() + motion.f_82480_;
        double newZ = this.m_20189_() + motion.f_82481_;
        this.m_6034_(newX, newY, newZ);
        if (this.spawnPos == null) {
            this.spawnPos = this.m_20182_();
        }
        if (this.m_142480_() == null) {
            this.m_146870_();
        }
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)new ColoredParticleData((ParticleType)ModParticles.SHORT_LIGHT.get(), 0.9647059f, 0.9882353f, 0.77254903f, 0.5f, 3.0f), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else if (this.m_142480_() != null) {
            Entity owner = this.m_142480_();
            Vec3 ownerPos = owner.m_20182_();
            double[] pos = switch (this.lightType) {
                default -> throw new IncompatibleClassChangeError();
                case Type.FRONT -> {
                    Vec3 look = this.m_142480_().m_20154_();
                    look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82490_(1.2);
                    yield MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)look.f_82479_, (double)0.0, (double)look.f_82481_, (float)((float)Math.PI / 180 * this.angleOffset));
                }
                case Type.PIERCING_SHORT, Type.PIERCING_LONG, Type.LONG -> MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)((double)owner.m_20205_() + 0.5), (double)0.0, (double)0.0, (float)((float)Math.PI / 180 * ((float)(13 * this.livingTicks) + this.angleOffset)));
                case Type.EXPAND -> MathUtils.rotate((double)0.0, (double)1.0, (double)0.0, (double)((double)owner.m_20205_() + (double)(this.livingTicks * this.livingTicks) * 0.01), (double)0.0, (double)0.0, (float)((float)Math.PI / 180 * ((float)(13 * this.livingTicks) + this.angleOffset)));
            };
            this.m_20334_(ownerPos.f_82479_ + pos[0] - this.m_20185_(), ownerPos.f_82480_ + (double)this.m_142480_().m_20206_() * 0.5 - this.m_20227_(0.5), ownerPos.f_82481_ + pos[2] - this.m_20189_());
            this.f_19812_ = true;
        }
    }

    protected boolean damageEntity(LivingEntity target) {
        if (CombatUtils.damageWithFaintAndCrit(this.m_142480_(), (Entity)target, new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().hurtResistant(0).element(EnumElement.LIGHT), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            if (this.lightType == Type.LONG || this.lightType == Type.EXPAND) {
                this.m_146870_();
            }
            if (this.firstDmg == -1) {
                this.firstDmg = this.livingTicks;
            }
            return true;
        }
        return false;
    }

    protected void onMaxEntities() {
        this.m_146870_();
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        try {
            this.lightType = Type.valueOf(compound.m_128461_("LightType"));
        }
        catch (IllegalArgumentException e) {
            this.lightType = Type.LONG;
        }
        this.angleOffset = compound.m_128457_("AngleOffset");
        if (compound.m_128441_("SpawnX")) {
            this.spawnPos = new Vec3(compound.m_128459_("SpawnX"), compound.m_128459_("SpawnY"), compound.m_128459_("SpawnZ"));
        }
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("LightType", this.lightType.toString());
        compound.m_128350_("AngleOffset", this.angleOffset);
        if (this.spawnPos != null) {
            compound.m_128347_("SpawnX", this.spawnPos.f_82479_);
            compound.m_128347_("SpawnY", this.spawnPos.f_82480_);
            compound.m_128347_("SpawnZ", this.spawnPos.f_82481_);
        }
    }

    public static enum Type {
        PIERCING_SHORT,
        PIERCING_LONG,
        LONG,
        FRONT,
        EXPAND;

    }
}

