/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class EntityLightBeam
extends BaseBeam {
    public EntityLightBeam(EntityType<? extends EntityLightBeam> type, Level world) {
        super(type, world);
    }

    public EntityLightBeam(Level world, LivingEntity shooter) {
        super((EntityType<? extends BaseBeam>)((EntityType)ModEntities.LIGHT_BEAM.get()), world, shooter);
    }

    public float getRange() {
        return 14.0f;
    }

    public float radius() {
        return 0.5f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return 25;
    }

    public void onImpact(EntityHitResult res) {
        CombatUtils.damageWithFaintAndCrit(this.m_142480_(), res.m_82443_(), new CustomDamage.Builder((Entity)this, this.m_142480_()).magic().noKnockback().hurtResistant(10).element(EnumElement.LIGHT), CombatUtils.getAttributeValue(this.m_142480_(), (Attribute)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
    }

    public boolean canStartDamage() {
        return this.livingTicks == 1;
    }
}

